<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\AccountCategory;
use App\Models\AccountSubCategory;
use App\Models\BlMaster;
use App\Models\BlContainerInfo;
use App\Models\Charge;
use App\Models\City;
use App\Models\Commodity;
use App\Models\Commodity_group;
use App\Models\Country;
use App\Models\Employee;
use App\Models\HsCode;
use App\Models\IncoTerm;
use App\Models\JobChargesPayable;
use App\Models\JobChargesReceivable;
use App\Models\JobDetail;
use App\Models\JobEquipments;
use App\Models\JobMaster;
use App\Models\JobOtherInfo;
use App\Models\JobRouting;
use App\Models\JobStatus;
use App\Models\JobVessel;
use App\Models\JobWeight;
use App\Models\Party;
use App\Models\PartyLocations;
use App\Models\PartyOperations;
use App\Models\PartyType;
use App\Models\Role;
use App\Models\ShipStatus;
use App\Models\SIJobOtherInfo;
use App\Models\AIJobOtherInfo;
use App\Models\AEJobOtherInfo;
use App\Models\ChartOfAccounts;
use App\Models\Transactions;
use App\Models\Un_location;
use App\Models\User;
use App\Models\Vessel;
use App\Models\Voyage;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Str;

class SEJobController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    // public function index(Request $request)
    // {
    //     $perPage = $request->input('perPage', session('perPage', 10));
    //     session(['perPage' => $perPage]);

    //     // Get filter parameters from the request
    //     $filterBy = $request->filterBy;
    //     $filterValue = null;

    //     if ($request->job_type) {
    //         $filterValue = $request->job_type;
    //     } else if ($request->cost_center) {
    //         $filterValue = $request->cost_center;
    //     } else if ($request->client_id) {
    //         $filterValue = $request->client_id;
    //     } else if ($request->shipper_id) {
    //         $filterValue = $request->shipper_id;
    //     } else if ($request->consignee_id) {
    //         $filterValue = $request->consignee_id;
    //     } else if ($request->sales_rep_id) {
    //         $filterValue = $request->sales_rep_id;
    //     } else if ($request->shipping_line_id) {
    //         $filterValue = $request->shipping_line_id;
    //     } else if ($request->local_vendor_id) {
    //         $filterValue = $request->local_vendor_id;
    //     } else if ($request->overseas_agent_id) {
    //         $filterValue = $request->overseas_agent_id;
    //     } else if ($request->vessel_id) {
    //         $filterValue = $request->vessel_id;
    //     } else if ($request->voyage_id) {
    //         $filterValue = $request->voyage_id;
    //     } else if ($request->job_status_id) {
    //         $filterValue = $request->job_status_id;
    //     } else if ($request->ship_status_id) {
    //         $filterValue = $request->ship_status_id;
    //     } else if ($request->commodity_id) {
    //         $filterValue = $request->commodity_id;
    //     } else if ($request->port_of_loading_id) {
    //         $filterValue = $request->port_of_loading_id;
    //     } else if ($request->port_of_discharge_id) {
    //         $filterValue = $request->port_of_discharge_id;
    //     } else {
    //         $filterValue = $request->filterValue;
    //     }
    //     // dd($filterBy, $filterValue);

    //     $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info'])
    //         ->where('operation_id', 1);
    //     if ($filterBy && $filterValue) {
    //         switch ($filterBy) {
    //             case 'id':
    //                 $se_jobs = JobMaster::where('id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'job_type':
    //                 $se_jobs = JobMaster::where('job_type', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'cost_center':
    //                 // $query->where('cost_center', $filterValue);
    //                 $se_jobs = JobMaster::where('cost_center', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'customer_reference_no':
    //                 $se_jobs = JobMaster::where('customer_reference_no', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'client_id':
    //                 // $se_jobs = JobDetail::where('client_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('client_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'shipper_id':
    //                 // $se_jobs = JobDetail::where('shipper_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('shipper_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'consignee_id':
    //                 // $se_jobs = JobDetail::where('consignee_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('consignee_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'sales_rep_id':
    //                 // $se_jobs = JobDetail::where('sales_rep_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('sales_rep_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'shipping_line_id':
    //                 // $se_jobs = JobDetail::where('shipping_line_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('shipping_line_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'local_vendor_id':
    //                 // $se_jobs = JobDetail::where('local_vendor_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('local_vendor_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'overseas_agent_id':
    //                 // $se_jobs = JobDetail::where('overseas_agent_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('overseas_agent_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'vessel_id':
    //                 // $se_jobs = JobVessel::where('vessel_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_vessel', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('vessel_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'voyage_id':
    //                 // $se_jobs = JobVessel::where('voyage_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_vessel', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('voyage_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'c_bkg_ed':
    //                 // $se_jobs = JobVessel::where('c_bkg_ed', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_vessel', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('c_bkg_ed', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'ship_status_id':
    //                 $se_jobs = JobMaster::where('ship_status_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'commodity_id':
    //                 // $se_jobs = JobDetail::where('commodity_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('commodity_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'port_of_loading_id':
    //                 // $se_jobs = JobDetail::where('port_of_loading_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('port_of_loading_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             case 'port_of_discharge_id':
    //                 // $se_jobs = JobDetail::where('port_of_discharge_id', $filterValue)->orderBy('id', 'Desc')->paginate($perPage);
    //                 $se_jobs = JobMaster::whereHas('job_detail', function ($subQuery) use ($filterValue) {
    //                     $subQuery->where('port_of_discharge_id', $filterValue);
    //                 })->orderBy('id', 'Desc')->paginate($perPage);
    //                 break;
    //             default:
    //                 // Handle other cases if necessary
    //                 // return redirect()->back()->with('error', 'Something Went Wrong!');
    //                 return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
    //             // break;
    //         }
    //     } else {
    //         $se_jobs = $query->orderBy('id', 'Desc')->paginate($perPage);
    //     }

    //     $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
    //     $shippers = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 1);
    //     })->get();
    //     $consignees = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 2);
    //     })->get();
    //     $shipping_line = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 12);
    //     })->get();
    //     $local_vendor = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->where('type_id', 6);
    //     })->get();
    //     $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
    //         $subQuery->whereIn('type_id', [7, 13]);
    //     })->get();
    //     $commodities = Commodity::where('status', 1)->get();
    //     $un_locations = Un_location::where('status', 1)->get();
    //     $sales_rep = Employee::where('status', 1)->get();
    //     $vessels = Vessel::where('status', 1)->get();
    //     $voyages = Voyage::where('status', 1)->get();
    //     $job_status = JobStatus::where('status', 1)->get();
    //     $ship_status = ShipStatus::where('status', 1)->get();
    //     // ->paginate($perPage);
    //     // $se_jobs::paginate($perPage);
    //     return view('sea_export.se_job.index', compact('se_jobs', 'perPage', 'clients', 'shippers', 'consignees', 'shipping_line', 'local_vendor', 'overseas_agent', 'commodities', 'un_locations', 'sales_rep', 'vessels', 'voyages', 'job_status', 'ship_status'));
    // }

    public function index(Request $request)
    {
        $perPage = $request->input('perPage', session('perPage', 100));
        session(['perPage' => $perPage]);

        // Get filter parameters from the request
        $filterBy = $request->filterBy;
        $filterValue = null;

        if ($request->job_type) {
            $filterValue = $request->job_type;
        } else if ($request->cost_center) {
            $filterValue = $request->cost_center;
        } else if ($request->client_id) {
            $filterValue = $request->client_id;
        } else if ($request->shipper_id) {
            $filterValue = $request->shipper_id;
        } else if ($request->consignee_id) {
            $filterValue = $request->consignee_id;
        } else if ($request->sales_rep_id) {
            $filterValue = $request->sales_rep_id;
        } else if ($request->shipping_line_id) {
            $filterValue = $request->shipping_line_id;
        } else if ($request->local_vendor_id) {
            $filterValue = $request->local_vendor_id;
        } else if ($request->overseas_agent_id) {
            $filterValue = $request->overseas_agent_id;
        } else if ($request->vessel_id) {
            $filterValue = $request->vessel_id;
        } else if ($request->voyage_id) {
            $filterValue = $request->voyage_id;
        } else if ($request->job_status_id) {
            $filterValue = $request->job_status_id;
        } else if ($request->ship_status_id) {
            $filterValue = $request->ship_status_id;
        } else if ($request->commodity_id) {
            $filterValue = $request->commodity_id;
        } else if ($request->port_of_loading_id) {
            $filterValue = $request->port_of_loading_id;
        } else if ($request->port_of_discharge_id) {
            $filterValue = $request->port_of_discharge_id;
        } else {
            $filterValue = $request->filterValue;
        }
        // $url = $request->getRequestUri();
        $url = $request->path();

        // dd($url);

        if ($url == "se_job") {
            $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
                ->where('operation_id', 1);
        } elseif ($url == "si_job") {
            $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
                ->where('operation_id', 2);
        } elseif ($url == "ae_job") {
            $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
                ->where('operation_id', 3);
        } elseif ($url == "ai_job") {
            $query = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_payable', 'job_charges', 'job_routing', 'job_other_info', 'bl_master'])
                ->where('operation_id', 4);
        }

        if ($filterBy && $filterValue) {
            switch ($filterBy) {
                case 'id':
                    $query->where('job_no', 'LIKE', "%$filterValue%");
                    break;
                case 'job_type':
                    $query->where('job_type', $filterValue);
                    break;
                case 'cost_center':
                    $query->where('cost_center', $filterValue);
                    break;
                case 'customer_reference_no':
                    $query->where('customer_reference_no', $filterValue);
                    break;
                case 'client_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('client_id', $filterValue);
                    });
                    break;
                case 'shipper_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('shipper_id', $filterValue);
                    });
                    break;
                case 'consignee_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('consignee_id', $filterValue);
                    });
                    break;
                case 'sales_rep_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('sales_rep_id', $filterValue);
                    });
                    break;
                case 'shipping_line_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('shipping_line_id', $filterValue);
                    });
                    break;
                case 'local_vendor_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('local_vendor_id', $filterValue);
                    });
                    break;
                case 'overseas_agent_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('overseas_agent_id', $filterValue);
                    });
                    break;
                case 'vessel_id':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('vessel_id', $filterValue);
                    });
                    break;
                case 'voyage_id':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('voyage_id', $filterValue);
                    });
                    break;
                case 'c_bkg_ed':
                    $query->whereHas('job_vessel', function ($subQuery) use ($filterValue) {
                        $subQuery->where('c_bkg_ed', $filterValue);
                    });
                    break;
                case 'ship_status_id':
                    $query->where('ship_status_id', $filterValue);
                    break;
                case 'commodity_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('commodity_id', $filterValue);
                    });
                    break;
                case 'port_of_loading_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('port_of_loading_id', $filterValue);
                    });
                    break;
                case 'port_of_discharge_id':
                    $query->whereHas('job_detail', function ($subQuery) use ($filterValue) {
                        $subQuery->where('port_of_discharge_id', $filterValue);
                    });
                    break;
                case 'hbl_no':
                    $query->whereHas('bl_master', function ($subQuery) use ($filterValue) {
                        $subQuery->where('hbl_no', $filterValue);
                    });
                    break;
                case 'mbl_no':
                    $query->whereHas('bl_master', function ($subQuery) use ($filterValue) {
                        $subQuery->where('mbl_no', $filterValue);
                    });
                    break;
                case 'file_number':
                    $query->where('file_no', $filterValue);
                    break;
                case 'container_no':
                    $query->whereHas('bl_master.bl_container_info', function ($subQuery) use ($filterValue) {
                        // $subQuery->where('container_no', $filterValue);
                        $subQuery->where('container_no', 'LIKE', "%$filterValue%");
                    });
                    break;
                default:
                    return redirect()->back()->with('error', 'Invalid filter key: ' . $filterBy);
            }
        }

        if ($request->job_status_id) {
            $query->where('job_status_id', $request->job_status_id);
        }

        if ($request->filled('date_filter')) {
            $dateFilter = $request->input('date_filter');
            if ($dateFilter == 'today') {
                $query->whereDate('created_at', today());
            } elseif ($dateFilter == 'this_week') {
                $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
            } elseif ($dateFilter == 'this_month') {
                $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
            } elseif ($dateFilter == 'custom') {
                if ($request->filled('date_from') && $request->filled('date_to')) {
                    $query->whereBetween('created_at', [$request->input('date_from'), $request->input('date_to')]);
                }
            }
        }

        $se_jobs = $query->orderBy('id', 'Desc')->paginate($perPage);

        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $local_vendor = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 6);
        })->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $commodities = Commodity::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $sales_rep = Employee::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $job_status = JobStatus::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();


        return view('sea_export.se_job.index', compact('se_jobs', 'perPage', 'vendors', 'clients', 'shippers', 'consignees', 'shipping_line', 'local_vendor', 'overseas_agent', 'commodities', 'un_locations', 'sales_rep', 'vessels', 'voyages', 'job_status', 'ship_status'));
    }


    public function add()
    {
        // $usersWithApprovedPermission = User::whereHas('roles.permissions', function ($subQuery) {
        //     $subQuery->where('title', 'Approved_Permission');
        // })->get();
        $rolesWithApprovedPermission = Role::whereHas('permissions.permission_master', function ($query) {
            $query->where('title', 'Approved_Permission');
        })->get();

        // dd($rolesWithApprovedPermission);

        $usersWithApprovedPermission = collect([]);

        foreach ($rolesWithApprovedPermission as $role) {
            $usersWithApprovedPermission = $usersWithApprovedPermission->merge($role->users);
        }
        $currentDate = Carbon::now()->format('Y-m-d');
        $currentDateTime = Carbon::now()->format('Y-m-d\TH:i');
        // dd($usersWithApprovedPermission);

        $inco_terms = IncoTerm::where('status', 1)->get();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $transportation = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 10);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $airline = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 17);
        })->get();
        $local_vendor = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 6);
        })->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();
        $sales_rep = Employee::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $charges = Charge::all();
        $job_status = JobStatus::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $hsCodes = HsCode::where('status', 1)->get();
        $commodity_groups = Commodity_group::where('status', 1)->get();
        $cities = City::where('status', 1)->get();
        $countries = Country::all();
        $party_types = PartyType::where('status', 1)->get();
        $party_operations = PartyOperations::all();
        $latest_seJob = JobMaster::where('operation_id', 1)->latest()->first();
        $latest_siJob = JobMaster::where('operation_id', 2)->latest()->first();
        $latest_aeJob = JobMaster::where('operation_id', 3)->latest()->first();
        $latest_aiJob = JobMaster::where('operation_id', 4)->latest()->first();
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        // $parent_accounts = ChartOfAccounts::all();
        $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();
        return view('sea_export.se_job.add', compact('airline', 'latest_seJob', 'latest_siJob', 'latest_aeJob', 'latest_aiJob', 'cities', 'countries', 'party_operations', 'party_types', 'vendors', 'ship_status', 'job_status', 'charges', 'inco_terms', 'transportation', 'custom_clearance', 'clients', 'un_locations', 'shippers', 'consignees', 'forwarded_coloader', 'vessels', 'overseas_agent', 'shipping_line', 'local_vendor', 'sales_rep', 'commodities', 'voyages', 'party_locations', 'hsCodes', 'commodity_groups', 'usersWithApprovedPermission', 'currentDate', 'currentDateTime', 'account_categories', 'account_sub_categories', 'parent_accounts'));
    }

    public function store(Request $request, LogsController $logController)
    {
        // dd($request->operation_id);
        try {
            $job_master = JobMaster::create([
                'operation_id' => $request->operation_id,
                'job_no' => $request->job_no,
                'cost_center' => $request->cost_center,
                'job_status_id' => $request->job_status_id,
                'freight_type' => $request->freight_type,
                'nature' => $request->nature,
                'console_id' => $request->console_id,
                'ship_status_id' => $request->ship_status_id,
                'nomination' => $request->nomination,
                'job_date' => $request->job_date,
                'job_kind' => $request->job_kind,
                'shipt_date' => $request->shipt_date,
                'file_no' => $request->file_no,
                'mty_move' => $request->mty_move,
                'part_fcl' => $request->part_fcl,
                'job_type' => $request->job_type,
                'sub_type_one' => $request->sub_type_one,
                'sub_type_two' => $request->sub_type_two,
                'customer_reference_no' => $request->customer_reference_no,
                'inco_term_id' => $request->inco_term_id,
                'book_reg' => $request->book_reg,
                'quotation' => $request->quotation,
                'quotation_no' => $request->quotation_no,
                'delivery' => $request->delivery,
                'tax_distribution' => $request->tax_distribution,
                'selling' => $request->selling,
                'buying' => $request->buying,
                'ex_rate' => $request->ex_rate,
                'principal_receivable' => $request->principal_receivable,
                'principal_payable' => $request->principal_payable,
                'principal_net' => $request->principal_net,
                'pp_receivable' => $request->pp_receivable,
                'cc_receivable' => $request->cc_receivable,
                'tax_total_receivable' => $request->tax_total_receivable,
                'total_receivable' => $request->total_receivable,
                'pp_payable' => $request->pp_payable,
                'cc_payable' => $request->cc_payable,
                'tax_total_payable' => $request->tax_total_payable,
                'total_payable' => $request->total_payable,
                'net' => $request->net,
                'status' => 1,
            ]);

            $job_detail = JobDetail::create([
                'job_master_id' => $job_master->id,
                'client_id' => $request->client_id,
                'shipper_id' => $request->shipper_id,
                'consignee_id' => $request->consignee_id,
                'commodity_id' => $request->commodity_id,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->port_of_discharge_id,
                'final_destination_id' => $request->final_destination_id,
                'custom_clearance_id' => $request->custom_clearance_id,
                'transportation_id' => $request->transportation_id,
                'forwarder_coloader_id' => $request->forwarder_coloader_id,
                'sales_rep_id' => $request->sales_rep_id,
                'shipping_line_id' => $request->shipping_line_id,
                'local_vendor_id' => $request->local_vendor_id,
                'overseas_agent_id' => $request->overseas_agent_id,

                'air_line_id' => $request->air_line_id,
                'status' => 1,
            ]);

            $job_vessel = JobVessel::create([
                'job_master_id' => $job_master->id,
                'vessel_id' => $request->vessel_id,
                'voyage_id' => $request->voyage_id,

                'airline_id' => $request->airline_id,
                'flight_no' => $request->flight_no,
                'cargo_pickup_id' => $request->cargo_pickup,
                'cargo_pickup_date' => $request->cargo_pickup_date,
                'cargo_dropoff_id' => $request->cargo_dropoff,
                'cargo_dropoff_date' => $request->cargo_dropoff_date,

                'c_bkg_ed' => $request->c_bkg_ed,
                'etd' => $request->etd,
                'eta' => $request->eta,
                'cut_off' => $request->cut_off,
                'status' => 1,
            ]);

            $job_weight = JobWeight::create([
                'job_master_id' => $job_master->id,
                'weight' => $request->weight,
                'container' => $request->container,
                'teu' => $request->teu,
                'pcs' => $request->pcs,

                'vol_wt' => $request->vol_wt,
                'cwt_line' => $request->cwt_line,
                'cwt_client' => $request->cwt_client,

                'bkg_wt' => $request->bkg_wt,
                'shp_vol' => $request->shp_vol,
                'vol' => $request->vol,
                'tracing_notes' => $request->tracing_notes,
                'status' => 1,
            ]);

            for ($i = 0; $i < $request->equipment_rows; $i++) {
                $job_equipments = JobEquipments::create([
                    'job_master_id' => $job_master->id,
                    'size_type' => $request['equipment_size_type'][$i],
                    'rate_group' => $request['equipment_rate_group'][$i],
                    'quantity' => $request['equipment_qty'][$i],
                    'dg_non_dg' => $request['equipment_dg_non_dg'][$i],
                    'gross_wt_cnt' => $request['equipment_gross_wt_cnt'][$i],
                    'teu' => $request['equipment_teu'][$i],
                    'status' => 1,
                ]);
            }
            // if (isset($request['receivable_charge_id']) && count($request['receivable_charge_id']) > 0)
            if (is_array($request['receivable_charge_id']) && array_filter($request['receivable_charge_id']) !== []) {

                foreach ($request['receivable_charge_id'] as $index => $charge_id) {
                    if (!empty($charge_id)) {
                        JobChargesReceivable::create([
                            'job_master_id' => $job_master->id,
                            'bill_invoice' => $request['receivable_bill_invoice'][$index] ?? null,
                            'charge_id' => $charge_id,
                            'description' => $request['receivable_description'][$index] ?? null,
                            'type' => $request['receivable_type'][$index] ?? null,
                            'basis' => $request['receivable_basis'][$index] ?? null,
                            'ppcc' => $request['receivable_ppcc'][$index] ?? null,
                            'size_type' => $request['receivable_size_type'][$index] ?? null,
                            'rate_group' => $request['receivable_rate_group'][$index] ?? null,
                            'dg_non_dg' => $request['receivable_dg_non_dg'][$index] ?? null,
                            'manual' => $request['receivable_manual'][$index] ?? null,
                            'qty' => $request['receivable_qty'][$index] ?? null,
                            'rate' => $request['receivable_ratee'][$index] ?? null,
                            'currency' => $request['receivable_currency'][$index] ?? null,
                            'margin' => $request['receivable_margin'][$index] ?? null,
                            'amount' => $request['receivable_amount'][$index] ?? null,
                            'discount' => $request['receivable_discount'][$index] ?? null,
                            'tax_apply' => $request['receivable_tax_apply'][$index] ?? null,
                            'tax_rev_share' => $request['receivable_tax_rev_share'][$index] ?? null,
                            'tax_amount_lc' => $request['receivable_tax_amount_lc'][$index] ?? null,
                            'net_amount' => $request['receivable_net_amount'][$index] ?? null,
                            'ex_rate' => $request['receivable_ex_rate'][$index] ?? null,
                            'local_amount' => $request['receivable_local_amount'][$index] ?? null,
                            'customer_id' => $request['receivable_customer_id'][$index] ?? $request->client_id,
                            'manifest_remarks' => $request['receivable_manifest_remarks'][$index] ?? null,
                            'tariff_code' => $request['receivable_tariff_code'][$index] ?? null,
                            'status' => 1,
                            'order_index' => $index,
                        ]);
                    }
                }
            }
            // if (is_array($request['receivable_charge_id']) && array_filter($request['receivable_charge_id']) !== []) {
            //     for ($i = 0; $i < $request->receivable_rows; $i++) {
            //         $job_charges_receivable = JobChargesReceivable::create([
            //             'job_master_id' => $job_master->id,
            //             'bill_invoice' => @$request['receivable_bill_invoice'][$i],
            //             'charge_id' => @$request['receivable_charge_id'][$i],
            //             // 'particular' => @$request['receivable_particular'][$i],s
            //             'description' => @$request['receivable_description'][$i],
            //             'type' => @$request['receivable_type'][$i],
            //             'basis' => @$request['receivable_basis'][$i],
            //             'ppcc' => @$request['receivable_ppcc'][$i],
            //             'size_type' => @$request['receivable_size_type'][$i],
            //             'rate_group' => @$request['receivable_rate_group'][$i],
            //             'dg_non_dg' => @$request['receivable_dg_non_dg'][$i],
            //             'manual' => @$request['receivable_manual'][$i],
            //             'qty' => @$request['receivable_qty'][$i],
            //             'rate' => @$request['receivable_ratee'][$i],
            //             'currency' => @$request['receivable_currency'][$i],
            //             'margin' => @$request['receivable_margin'][$i],
            //             'amount' => @$request['receivable_amount'][$i],
            //             'discount' => @$request['receivable_discount'][$i],
            //             'tax_apply' => @$request['receivable_tax_apply'][$i],
            //             'tax_rev_share' => @$request['receivable_tax_rev_share'][$i],
            //             'tax_amount_lc' => @$request['receivable_tax_amount_lc'][$i],
            //             'net_amount' => @$request['receivable_net_amount'][$i],
            //             'ex_rate' => @$request['receivable_ex_rate'][$i],
            //             'local_amount' => @$request['receivable_local_amount'][$i],
            //             // 'customer_code' => @$request['receivable_customer_code'][$i],
            //             'customer_id' => @$request['receivable_customer_id'][$i],
            //             'manifest_remarks' => @$request['receivable_manifest_remarks'][$i],
            //             'tariff_code' => @$request['receivable_tariff_code'][$i],
            //             // 'approved' => @$request['receivable_approved'][$i],
            //             // 'approved_by' => @$request['receivable_approved_by'][$i],
            //             // 'approved_date' => @$request['receivable_approved_date'][$i],
            //             // 'approved_date' => Carbon::now(),
            //             // 'approval_log' => Carbon::now(),
            //             'status' => 1,
            //         ]);
            //     }
            // }

            // if (!is_null($request['payable_charge_id'])) {
            // if (isset($request['payable_charge_id']) && count($request['payable_charge_id']) > 0)
            if (is_array($request['payable_charge_id']) && array_filter($request['payable_charge_id']) !== []) {

                foreach ($request['payable_charge_id'] as $index => $charge_id) {
                    if (!empty($charge_id)) {
                        // for ($i = 0; $i < $loop_index; $i++) {
                        $job_charges_payable = JobChargesPayable::create([
                            'job_master_id' => $job_master->id,
                            'bill_invoice' => @$request['payable_bill_invoice'][$index],
                            'charge_id' => @$request['payable_charge_id'][$index],
                            // 'particular' => @$request['payable_particular'][$i],
                            'description' => @$request['payable_description'][$index],
                            'type' => @$request['payable_type'][$index],
                            'basis' => @$request['payable_basis'][$index],
                            'ppcc' => @$request['payable_ppcc'][$index],
                            'size_type' => @$request['payable_size_type'][$index],
                            'rate_group' => @$request['payable_rate_group'][$index],
                            'dg_non_dg' => @$request['payable_dg_non_dg'][$index],
                            'manual' => @$request['payable_manual'][$index],
                            'qty' => @$request['payable_qty'][$index],
                            'rate' => @$request['payable_ratee'][$index],
                            'currency' => @$request['payable_currency'][$index],
                            'margin' => @$request['payable_margin'][$index],
                            'amount' => @$request['payable_amount'][$index],
                            'discount' => @$request['payable_discount'][$index],
                            'tax_apply' => @$request['payable_tax_apply'][$index],
                            'tax_rev_share' => @$request['payable_tax_rev_share'][$index],
                            'tax_amount_lc' => @$request['payable_tax_amount_lc'][$index],
                            'net_amount' => @$request['payable_net_amount'][$index],
                            'ex_rate' => @$request['payable_ex_rate'][$index],
                            'local_amount' => @$request['payable_local_amount'][$index],
                            'vendor_code' => @$request['payable_vendor_code'][$index],
                            'vendor_id' => @$request['payable_vendor_id'][$index],
                            'manifest_remarks' => @$request['payable_manifest_remarks'][$index],
                            'tariff_code' => @$request['payable_tariff_code'][$index],
                            // 'approved' => @$request['payable_approved'][$i],
                            // 'approved_by' => @$request['payable_approved_by'][$i],
                            // 'approved_date' => Carbon::now(),
                            // 'approved_date' => @$request['payable_approved_date'][$i],
                            // 'approval_log' => Carbon::now(),
                            'status' => 1,
                            'order_index' => $index,
                        ]);
                    }
                }
            }
            // if (is_array($request['payable_charge_id']) && array_filter($request['payable_charge_id']) !== []) {
            //     for ($i = 0; $i < $request->payable_rows; $i++) {
            //         $job_charges_payable = JobChargesPayable::create([
            //             'job_master_id' => $job_master->id,
            //             'bill_invoice' => @$request['payable_bill_invoice'][$i],
            //             'charge_id' => @$request['payable_charge_id'][$i],
            //             // 'particular' => @$request['payable_particular'][$i],
            //             'description' => @$request['payable_description'][$i],
            //             'type' => @$request['payable_type'][$i],
            //             'basis' => @$request['payable_basis'][$i],
            //             'ppcc' => @$request['payable_ppcc'][$i],
            //             'size_type' => @$request['payable_size_type'][$i],
            //             'rate_group' => @$request['payable_rate_group'][$i],
            //             'dg_non_dg' => @$request['payable_dg_non_dg'][$i],
            //             'manual' => @$request['payable_manual'][$i],
            //             'qty' => @$request['payable_qty'][$i],
            //             'rate' => @$request['payable_ratee'][$i],
            //             'currency' => @$request['payable_currency'][$i],
            //             'margin' => @$request['payable_margin'][$i],
            //             'amount' => @$request['payable_amount'][$i],
            //             'discount' => @$request['payable_discount'][$i],
            //             'tax_apply' => @$request['payable_tax_apply'][$i],
            //             'tax_rev_share' => @$request['payable_tax_rev_share'][$i],
            //             'tax_amount_lc' => @$request['payable_tax_amount_lc'][$i],
            //             'net_amount' => @$request['payable_net_amount'][$i],
            //             'ex_rate' => @$request['payable_ex_rate'][$i],
            //             'local_amount' => @$request['payable_local_amount'][$i],
            //             'vendor_code' => @$request['payable_vendor_code'][$i],
            //             'vendor_id' => @$request['payable_vendor_id'][$i],
            //             'manifest_remarks' => @$request['payable_manifest_remarks'][$i],
            //             'tariff_code' => @$request['payable_tariff_code'][$i],
            //             // 'approved' => @$request['payable_approved'][$i],
            //             // 'approved_by' => @$request['payable_approved_by'][$i],
            //             // 'approved_date' => Carbon::now(),
            //             // 'approved_date' => @$request['payable_approved_date'][$i],
            //             // 'approval_log' => Carbon::now(),
            //             'status' => 1,
            //         ]);
            //     }
            // }

            $job_routing = JobRouting::create([
                'job_master_id' => $job_master->id,
                'service_type' => $request->service_type,
                'place_of_receipt_id' => $request->routing_place_of_receipt_id,
                'receipt_date' => $request->routing_receipt_date,
                'port_of_loading_id' => $request->routing_port_of_loading_id,
                'loading_date' => $request->routing_loading_date,
                'port_of_discharge_id' => $request->routing_port_of_discharge_id,
                'discharge_date' => $request->routing_discharge_date,
                'port_of_trashipment_id' => $request->routing_port_of_trashipment_id,
                'trashipment_date' => $request->routing_trashipment_date,
                'final_destination_id' => $request->routing_final_destination_id,
                'freight_payable_at' => $request->freight_payable_at,
                'cfs_depot_facility' => $request->depot_facility,
                'terminal_id' => $request->terminal_id,
                'delivery' => $request->routing_delivery,
                'trashipment' => $request->trashipment,
                'buyer' => $request->buyer,
                'via_port' => $request->via_port_id,
                'vessel_id' => $request->feeder_vessel_id,
                'voyage_id' => $request->routing_voyage_id,
                'status' => 1,
            ]);

            if ((int) $request->operation_id == 1) {
                $job_other_info = JobOtherInfo::create([
                    'job_master_id' => $job_master->id,
                    'agree_rate' => $request->agree_rate,
                    'transhipment_cargo' => $request->transhipment_cargo,
                    'remarks' => $request->remarks,
                    'any_other_information' => $request->any_other_information,
                    'cargo_manifest_remarks' => $request->cargo_menifest_remarks,
                    'document_type_id' => $request->document_type_id,
                    'document_type_remarks' => $request->document_type_remarks,
                    'buyer_id' => $request->buyer_id,
                    'buying_house' => $request->buying_house,
                    'no_of_original_bl' => $request->no_of_original_bill,
                    'destination_charges' => $request->destination_charges,
                    'cargo_pickup_id' => $request->cargo_pickup,
                    'cargo_pickup_date' => $request->cargo_pickup_date,
                    'container_pickup_id' => $request->container_pcikup,
                    'pickup_ref' => $request->pickup_ref_no,
                    'cargo_dropoff' => $request->cargo_dropoff,
                    'cargo_dropoff_date' => $request->cargo_dropoff_date,
                    'container_drop_id' => $request->container_dropoff,
                    'dropoff_ref' => $request->dropoff_ref_no,
                    'aes_no' => $request->aes_no,
                    'telex_no' => $request->telex_no,
                    'b13_no' => $request->b13_no,
                    'status' => 1,
                ]);
            }

            if ((int) $request->operation_id == 2) {
                $job_other_info = SIJobOtherInfo::create([
                    'job_master_id' => $job_master->id,
                    'remarks' => $request->remarks,
                    'document_type' => $request->document_type,
                    'document_type_remarks' => $request->document_type_remarks,
                    'lc' => $request->lc,
                    'lc_date' => $request->lc_date,
                    'delivery_date' => $request->delivery_date,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                    'it_number' => $request->it_number,
                    'it_location_date' => $request->it_location_date,
                    'cprs_number' => $request->cprs_number,
                    'cprs_location_date' => $request->cprs_location_date,
                    'bank_endorsement' => $request->bankEndorsement,
                    'doc_required' => $request->doc_required,
                    'doc_record_By' => $request->doc_record_By,
                    'doc_rcv_date' => $request->doc_rcv_date,
                    'pod_send_by' => $request->pod_send_by,
                    'pod_date' => $request->pod_date,
                    'sub_bl_no' => $request->sub_bl_no,
                    'buyer_id' => $request->buyer_id,
                    'buying_house' => $request->buying_house,
                    'cargo_pickup' => $request->cargo_pickup,
                    'cargo_pickup_date' => $request->cargo_pickup_date,
                    'container_pickup' => $request->container_pickup,
                    'pickup_ref_no' => $request->pickup_ref_no,
                    'cargo_dropoff' => $request->cargo_dropoff,
                    'cargo_dropoff_date' => $request->cargo_dropoff_date,
                    'container_dropoff' => $request->container_dropoff,
                    'dropoff_ref_no' => $request->dropoff_ref_no,
                ]);
            }
            if ((int) $request->operation_id == 3) {
                $job_other_info = AEJobOtherInfo::create([
                    'job_master_id' => $job_master->id,
                    'agree_rate' => $request->agree_rate,
                    'remarks' => $request->remarks,
                    'document_type_id' => $request->document_type_id,
                    'document_type_remarks' => $request->document_type_remarks,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                ]);
            }
            if ((int) $request->operation_id == 4) {
                $job_other_info = AIJobOtherInfo::create([
                    'job_master_id' => $job_master->id,
                    'remarks' => $request->remarks,
                    'document_type_remarks' => $request->document_type_remarks,
                    'cargo_type' => $request->cargo_type,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                    'bank_endorsement' => $request->bankEndorsement,
                    'doc_required' => $request->docRequired,
                    'doc_record_by' => $request->docRecordBy,
                    'doc_rcv_date' => $request->docRcvDate,
                    'pod_send_by' => $request->podSendBy,
                    'pod_date' => $request->podDate,
                    'it_number' => $request->it_number,
                    'it_location_date' => $request->it_location_date,
                    'cprs_number' => $request->cprs_number,
                    'cprs_location_date' => $request->cprs_location_date,
                    'invoice_no' => $request->invoice_no,
                    'invoice_date' => $request->invoice_date,
                    'export_no' => $request->export_no,
                    'export_date' => $request->export_date,
                    'contract_no' => $request->contract_no,
                    'contract_date' => $request->contract_date,
                    'lc' => $request->lc,
                    'lc_date' => $request->lc_date,
                    'req_docs' => $request->req_docs,
                ]);
            }
            $innertabId = '';
            $tabId = $request->input('tabId');
            if ($tabId === 'payable') {
                $tabId = 'charges';
                $innertabId = 'payable';
            } else if ($tabId === 'receivable') {
                $tabId = 'charges';
                $innertabId = 'receivable';
            }

            $logController->createLog(__METHOD__, 'success', 'SE JOB Created.', auth()->user(), '');

            if ($job_master->operation_id == 1) {
                return redirect()->to('/se_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Created SuccessFully!');
            } elseif ($job_master->operation_id == 2) {
                return redirect()->to('/si_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Created SuccessFully!');
            } elseif ($job_master->operation_id == 3) {
                return redirect()->to('/ae_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Created SuccessFully!');
            } elseif ($job_master->operation_id == 4) {
                return redirect()->to('/ai_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Created SuccessFully!');
            } else {
                return redirect()->to('/dashboard')->with('success', 'Record Created SuccessFully!');
            }
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function edit(JobMaster $job_master)
    {
        $rolesWithApprovedPermission = Role::whereHas('permissions.permission_master', function ($query) {
            $query->where('title', 'Approved_Permission');
        })->get();

        $usersWithApprovedPermission = collect([]);

        foreach ($rolesWithApprovedPermission as $role) {
            $usersWithApprovedPermission = $usersWithApprovedPermission->merge($role->users);
        }
        // $job_charges_receivable = JobChargesReceivable::where('job_master_id', $job_master->id)->get();
        // $billInvoiceValues = $job_charges_receivable->pluck('bill_invoice');
        // $transaction = Transactions::whereIn('tran_no', $billInvoiceValues)
        //     ->where('job_master_id', $job_master->id)
        //     ->get();
        //     dd($transaction);
        // $transaction = Transactions::where('job_master_id', $job_master->id)->first();
        $currentDate = Carbon::now()->format('Y-m-d');
        $currentDateTime = Carbon::now()->format('Y-m-d\TH:i');
        $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_receivable.transaction_charges', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('id', $job_master->id)->first();
        $inco_terms = IncoTerm::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        $vendors = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        $shippers = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 1);
        })->get();
        $consignees = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 2);
        })->get();
        $custom_clearance = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 11);
        })->get();
        $transportation = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 10);
        })->get();
        $forwarded_coloader = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 5);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $airline = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 17);
        })->get();
        $local_vendor = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 6);
        })->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        $commodities = Commodity::where('status', 1)->get();
        // dd($commodities);
        $un_locations = Un_location::where('status', 1)->get();
        $sales_rep = Employee::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $charges = Charge::all();
        $job_status = JobStatus::where('status', 1)->get();
        $ship_status = ShipStatus::where('status', 1)->get();
        $cities = City::where('status', 1)->get();
        $countries = Country::all();
        $party_types = PartyType::where('status', 1)->get();
        $party_operations = PartyOperations::all();
        $hsCodes = HsCode::where('status', 1)->get();
        $commodity_groups = Commodity_group::where('status', 1)->get();
        $bl_master = BlMaster::where('job_master_id', $job_master->id)->first();
        $bl_container_info = $bl_master ? BLContainerInfo::where('bl_master_id', $bl_master->id)->first() : null;
        // dd($bl_master->bl_detail);

        $containerNo = '';
        $count = 0;
        $totalPackages = 0;
        $teu = 0;
        $selectedContainerSizeType = null;

        if ($bl_master && $bl_master->bl_container_info) {
            // Get the first index value of container_size_type
            // $firstContainerSizeType = @$bl_master->bl_container_info->first()->container_size_type;
            // dd($firstContainerSizeType);
            $containerSizeTypes = $bl_master->bl_container_info->pluck('container_size_type');

            $mostSelectedContainerSizeType = $containerSizeTypes->countBy()->sortDesc()->keys()->first();

            // Now you can assign it to a variable
            $selectedContainerSizeType = $mostSelectedContainerSizeType;
            foreach ($bl_master->bl_container_info as $container) {
                $containerNo = $bl_master->bl_container_info->pluck('container_no')->implode(', ');
                $count = $bl_master->bl_container_info->count();
                $totalPackages += (float) $container->container_packages;
            }

            // // Check if the initial of the container size type is 40 or 45
            // if (Str::startsWith($firstContainerSizeType, ['40', '45'])) {
            //     $teu = $count * 2;
            // } else {
            //     $teu = $count;
            // }
        }

        $containerInfo = @$bl_master->bl_container_info;
        $groupedContainers = [];
        $teu = 0;
        $totalTeu = 0;

        if ($containerInfo) {
            foreach ($containerInfo as $container) {
                $type = $container->container_size_type;
                if (!isset($groupedContainers[$type])) {
                    $groupedContainers[$type] = [
                        'count' => 0,
                        'total_packages' => 0,
                        'teu' => 0,
                        'rate_group' => $container->container_rate_group
                    ];
                }
                $groupedContainers[$type]['count']++;
                $groupedContainers[$type]['total_packages'] += (float) $container->container_packages;

                // Calculate TEU
                if (Str::startsWith($type, ['40', '45'])) {
                    $groupedContainers[$type]['teu'] += 2;
                } else {
                    $groupedContainers[$type]['teu'] += 1;
                }
            }
            foreach ($groupedContainers as $container) {
                $totalTeu += $container['teu'];
            }
        }
        $account_categories = AccountCategory::all();
        $account_sub_categories = AccountSubCategory::all();
        // $parent_accounts = ChartOfAccounts::all();
        $parent_accounts = ChartOfAccounts::whereIn('level', [2, 3])->get();

        return view('sea_export.se_job.edit', compact('cities', 'airline', 'overseas_agent', 'selectedContainerSizeType', 'countries', 'totalTeu', 'groupedContainers', 'party_operations', 'party_types', 'job_master', 'vendors', 'ship_status', 'job_status', 'charges', 'inco_terms', 'transportation', 'custom_clearance', 'clients', 'un_locations', 'shippers', 'consignees', 'forwarded_coloader', 'vessels', 'overseas_agent', 'shipping_line', 'local_vendor', 'sales_rep', 'commodities', 'voyages', 'party_locations', 'currentDate', 'currentDateTime', 'commodity_groups', 'hsCodes', 'usersWithApprovedPermission', 'bl_master', 'containerNo', 'count', 'bl_container_info', 'totalPackages', 'teu', 'account_categories', 'account_sub_categories', 'parent_accounts', ));
    }

    public function update(JobMaster $job_master, Request $request, LogsController $logController)
    {
        try {
            JobMaster::where('id', $job_master->id)->update([
                'operation_id' => $request->operation_id,
                'job_no' => $request->job_no,
                'cost_center' => $request->cost_center,
                'job_status_id' => $request->job_status_id,
                'freight_type' => $request->freight_type,
                'nature' => $request->nature,
                'console_id' => $request->console_id,
                'ship_status_id' => $request->ship_status_id,
                'nomination' => $request->nomination,
                'job_date' => $request->job_date,
                'job_kind' => $request->job_kind,
                'shipt_date' => $request->shipt_date,
                'file_no' => $request->file_no,
                'mty_move' => $request->mty_move,
                'part_fcl' => $request->part_fcl,
                'job_type' => $request->job_type,
                'sub_type_one' => $request->sub_type_one,
                'sub_type_two' => $request->sub_type_two,
                'customer_reference_no' => $request->customer_reference_no,
                'inco_term_id' => $request->inco_term_id,
                'book_reg' => $request->book_reg,
                'quotation' => $request->quotation,
                'quotation_no' => $request->quotation_no,
                'delivery' => $request->delivery,
                'tax_distribution' => $request->tax_distribution,
                'selling' => $request->selling,
                'buying' => $request->buying,
                'ex_rate' => $request->ex_rate,
                'principal_receivable' => $request->principal_receivable,
                'principal_payable' => $request->principal_payable,
                'principal_net' => $request->principal_net,
                'pp_receivable' => $request->pp_receivable,
                'cc_receivable' => $request->cc_receivable,
                'tax_total_receivable' => $request->tax_total_receivable,
                'total_receivable' => $request->total_receivable,
                'pp_payable' => $request->pp_payable,
                'cc_payable' => $request->cc_payable,
                'tax_total_payable' => $request->tax_total_payable,
                'total_payable' => $request->total_payable,
                'net' => $request->net,
                // 'status' => 1,
            ]);

            $job_detail = JobDetail::where('job_master_id', $job_master->id)->update([
                'job_master_id' => $job_master->id,
                'client_id' => $request->client_id,
                'shipper_id' => $request->shipper_id,
                'consignee_id' => $request->consignee_id,
                'commodity_id' => $request->commodity_id,
                'port_of_loading_id' => $request->port_of_loading_id,
                'port_of_discharge_id' => $request->port_of_discharge_id,
                'final_destination_id' => $request->final_destination_id,
                'custom_clearance_id' => $request->custom_clearance_id,
                'transportation_id' => $request->transportation_id,
                'forwarder_coloader_id' => $request->forwarder_coloader_id,
                'sales_rep_id' => $request->sales_rep_id,
                'shipping_line_id' => $request->shipping_line_id,
                'local_vendor_id' => $request->local_vendor_id,
                'overseas_agent_id' => $request->overseas_agent_id,
                'air_line_id' => $request->air_line_id,
                // 'status' => 1,
            ]);

            $job_vessel = JobVessel::where('job_master_id', $job_master->id)->update([
                'job_master_id' => $job_master->id,
                'vessel_id' => $request->vessel_id,
                'voyage_id' => $request->voyage_id,
                'airline_id' => $request->airline_id,
                'flight_no' => $request->flight_no,
                'cargo_pickup_id' => $request->cargo_pickup,
                'cargo_pickup_date' => $request->cargo_pickup_date,
                'cargo_dropoff_id' => $request->cargo_dropoff,
                'cargo_dropoff_date' => $request->cargo_dropoff_date,
                'c_bkg_ed' => $request->c_bkg_ed,
                'etd' => $request->etd,
                'eta' => $request->eta,
                'cut_off' => $request->cut_off,
                // 'status' => 1,
            ]);

            $job_weight = JobWeight::where('job_master_id', $job_master->id)->update([
                'job_master_id' => $job_master->id,
                'weight' => $request->weight,
                'container' => $request->container,
                'teu' => $request->teu,
                'pcs' => $request->pcs,
                'vol_wt' => $request->vol_wt,
                'cwt_line' => $request->cwt_line,
                'cwt_client' => $request->cwt_client,
                'bkg_wt' => $request->bkg_wt,
                'shp_vol' => $request->shp_vol,
                'vol' => $request->vol,
                'tracing_notes' => $request->tracing_notes,
                // 'status' => 1,
            ]);

            JobEquipments::where('job_master_id', $job_master->id)->delete();
            for ($i = 0; $i < $request->equipment_rows; $i++) {
                $job_equipments = JobEquipments::create([
                    'job_master_id' => $job_master->id,
                    'size_type' => @$request['equipment_size_type'][$i],
                    'rate_group' => @$request['equipment_rate_group'][$i],
                    'quantity' => @$request['equipment_qty'][$i],
                    'dg_non_dg' => @$request['equipment_dg_non_dg'][$i],
                    'gross_wt_cnt' => @$request['equipment_gross_wt_cnt'][$i],
                    'status' => 1,
                ]);
            }

            if (is_array($request['receivable_charge_id']) && array_filter($request['receivable_charge_id']) !== []) {
                // Delete only records where status = 1
                // dd($request['receivable_charge_id']);
                JobChargesReceivable::where('job_master_id', $job_master->id)
                    ->where('status', 1)
                    ->delete();

                foreach ($request['receivable_charge_id'] as $index => $charge_id) {

                    // Continue if receivable_charge_id or required fields are missing
                    if (empty($charge_id) || !isset($request['rec_bill_check'][$index]) || $request['rec_bill_check'][$index] != 1) {
                        continue;
                    }

                    // Create new JobChargesReceivable record
                    JobChargesReceivable::create([
                        'job_master_id' => $job_master->id,
                        'bill_invoice' => $request['receivable_bill_invoice'][$index] ?? null,
                        'charge_id' => $charge_id,
                        'description' => $request['receivable_description'][$index] ?? null,
                        'type' => $request['receivable_type'][$index] ?? null,
                        'basis' => $request['receivable_basis'][$index] ?? null,
                        'ppcc' => $request['receivable_ppcc'][$index] ?? null,
                        'size_type' => $request['receivable_size_type'][$index] ?? null,
                        'rate_group' => $request['receivable_rate_group'][$index] ?? null,
                        'dg_non_dg' => $request['receivable_dg_non_dg'][$index] ?? null,
                        'manual' => $request['receivable_manual'][$index] ?? null,
                        'qty' => $request['receivable_qty'][$index] ?? null,
                        'rate' => $request['receivable_ratee'][$index] ?? null,
                        'currency' => $request['receivable_currency'][$index] ?? null,
                        'margin' => $request['receivable_margin'][$index] ?? null,
                        'amount' => $request['receivable_amount'][$index] ?? null,
                        'discount' => $request['receivable_discount'][$index] ?? null,
                        'tax_apply' => $request['receivable_tax_apply'][$index] ?? null,
                        'tax_rev_share' => $request['receivable_tax_rev_share'][$index] ?? null,
                        'tax_amount_lc' => $request['receivable_tax_amount_lc'][$index] ?? null,
                        'net_amount' => $request['receivable_net_amount'][$index] ?? null,
                        'ex_rate' => $request['receivable_ex_rate'][$index] ?? null,
                        'local_amount' => $request['receivable_local_amount'][$index] ?? null,
                        'customer_id' => $request['receivable_customer_id'][$index] ?? $request->client_id,
                        'manifest_remarks' => $request['receivable_manifest_remarks'][$index] ?? null,
                        'tariff_code' => $request['receivable_tariff_code'][$index] ?? null,
                        'status' => 1,
                        'order_index' => $index,
                    ]);
                }
            }


            // for ($i = 0; $i < count($request->payable_rows); $i++) {
            //     $job_charges_payable = JobChargesPayable::updateorCreate(['id' => @$request->job_payable_id[$i]], [
            // if (isset($request['payable_charge_id']) && count($request['payable_charge_id']) > 0) {
            if (is_array($request['payable_charge_id']) && array_filter($request['payable_charge_id']) !== []) {

                // Get records with status != 1 (those that should not be deleted)
                // $nonDeletablePayables = JobChargesPayable::where('job_master_id', $job_master->id)
                //     ->where('status', '!=', 1)
                //     ->pluck('charge_id')
                //     ->toArray(); // Collect charge IDs that shouldn't be deleted

                JobChargesPayable::where('job_master_id', $job_master->id)
                    ->where('status', 1)
                    ->delete();

                // Create new records for the remaining charge_ids
                foreach ($request['payable_charge_id'] as $index => $charge_id) {

                    if (empty($charge_id) || !isset($request['pay_bill_check'][$index]) || $request['pay_bill_check'][$index] != 1) {
                        continue;
                    }
                    $job_charges_payable = JobChargesPayable::create([
                        'job_master_id' => $job_master->id,
                        'bill_invoice' => @$request['payable_bill_invoice'][$index],
                        'charge_id' => @$request['payable_charge_id'][$index],
                        'description' => @$request['payable_description'][$index],
                        'type' => @$request['payable_type'][$index],
                        'basis' => @$request['payable_basis'][$index],
                        'ppcc' => @$request['payable_ppcc'][$index],
                        'size_type' => @$request['payable_size_type'][$index],
                        'rate_group' => @$request['payable_rate_group'][$index],
                        'dg_non_dg' => @$request['payable_dg_non_dg'][$index],
                        'manual' => @$request['payable_manual'][$index],
                        'qty' => @$request['payable_qty'][$index],
                        'rate' => @$request['payable_ratee'][$index],
                        'currency' => @$request['payable_currency'][$index],
                        'margin' => @$request['payable_margin'][$index],
                        'amount' => @$request['payable_amount'][$index],
                        'discount' => @$request['payable_discount'][$index],
                        'tax_apply' => @$request['payable_tax_apply'][$index],
                        'tax_rev_share' => @$request['payable_tax_rev_share'][$index],
                        'tax_amount_lc' => @$request['payable_tax_amount_lc'][$index],
                        'net_amount' => @$request['payable_net_amount'][$index],
                        'ex_rate' => @$request['payable_ex_rate'][$index],
                        'local_amount' => @$request['payable_local_amount'][$index],
                        'vendor_code' => @$request['payable_vendor_code'][$index],
                        'vendor_id' => @$request['payable_vendor_id'][$index],
                        'manifest_remarks' => @$request['payable_manifest_remarks'][$index],
                        'tariff_code' => @$request['payable_tariff_code'][$index],
                        'status' => 1,
                        'order_index' => $index,
                    ]);
                }
            }


            $job_routing = JobRouting::where('job_master_id', $job_master->id)->update([
                'job_master_id' => $job_master->id,
                'service_type' => $request->service_type,
                'place_of_receipt_id' => $request->routing_place_of_receipt_id,
                'receipt_date' => $request->routing_receipt_date,
                'port_of_loading_id' => $request->routing_port_of_loading_id,
                'loading_date' => $request->routing_loading_date,
                'port_of_discharge_id' => $request->routing_port_of_discharge_id,
                'discharge_date' => $request->routing_discharge_date,
                'port_of_trashipment_id' => $request->routing_port_of_trashipment_id,
                'trashipment_date' => $request->routing_trashipment_date,
                'final_destination_id' => $request->routing_final_destination_id,
                'freight_payable_at' => $request->freight_payable_at,
                'cfs_depot_facility' => $request->depot_facility,
                'terminal_id' => $request->terminal_id,
                'delivery' => $request->delivery,
                'trashipment' => $request->trashipment,
                'via_port' => $request->via_port_id,
                'vessel_id' => $request->feeder_vessel_id,
                'voyage_id' => $request->routing_voyage_id,
                'status' => 1,
            ]);

            // $job_other_info = JobOtherInfo::where('job_master_id', $job_master->id)->update([
            //     'job_master_id' => $job_master->id,
            //     'agree_rate' => $request->agree_rate,
            //     'transhipment_cargo' => $request->transhipment_cargo,
            //     'remarks' => $request->remarks,
            //     'any_other_information' => $request->any_other_information,
            //     'cargo_manifest_remarks' => $request->cargo_menifest_remarks,
            //     'document_type_id' => $request->document_type_id,
            //     'document_type_remarks' => $request->document_type_remarks,
            //     'buyer_id' => $request->buyer_id,
            //     'buying_house' => $request->buying_house,
            //     'no_of_original_bl' => $request->no_of_original_bill,
            //     'destination_charges' => $request->destination_charges,
            //     'cargo_pickup_id' => $request->cargo_pickup,
            //     'cargo_pickup_date' => $request->cargo_pickup_date,
            //     'container_pickup_id' => $request->container_pcikup,
            //     'pickup_ref' => $request->pickup_ref_no,
            //     'cargo_dropoff' => $request->cargo_dropoff,
            //     'cargo_dropoff_date' => $request->cargo_dropoff_date,
            //     'container_drop_id' => $request->container_dropoff,
            //     'dropoff_ref' => $request->dropoff_ref_no,
            //     'aes_no' => $request->aes_no,
            //     'telex_no' => $request->telex_no,
            //     'b13_no' => $request->b13_no,
            //     'status' => 1,
            // ]);

            if ((int) $request->operation_id == 1) {
                $job_other_info = JobOtherInfo::where('job_master_id', $job_master->id)->update([
                    'job_master_id' => $job_master->id,
                    'agree_rate' => $request->agree_rate,
                    'transhipment_cargo' => $request->transhipment_cargo,
                    'remarks' => $request->remarks,
                    'any_other_information' => $request->any_other_information,
                    'cargo_manifest_remarks' => $request->cargo_menifest_remarks,
                    'document_type_id' => $request->document_type_id,
                    'document_type_remarks' => $request->document_type_remarks,
                    'buyer_id' => $request->buyer_id,
                    'buying_house' => $request->buying_house,
                    'no_of_original_bl' => $request->no_of_original_bill,
                    'destination_charges' => $request->destination_charges,
                    'cargo_pickup_id' => $request->cargo_pickup,
                    'cargo_pickup_date' => $request->cargo_pickup_date,
                    'container_pickup_id' => $request->container_pcikup,
                    'pickup_ref' => $request->pickup_ref_no,
                    'cargo_dropoff' => $request->cargo_dropoff,
                    'cargo_dropoff_date' => $request->cargo_dropoff_date,
                    'container_drop_id' => $request->container_dropoff,
                    'dropoff_ref' => $request->dropoff_ref_no,
                    'aes_no' => $request->aes_no,
                    'telex_no' => $request->telex_no,
                    'b13_no' => $request->b13_no,
                    'status' => 1,
                ]);
            }

            if ($request->operation_id == 2) {
                $job_other_info = SIJobOtherInfo::where('job_master_id', $job_master->id)->update([
                    'job_master_id' => $job_master->id,
                    'remarks' => $request->remarks,
                    'document_type' => $request->document_type,
                    'document_type_remarks' => $request->document_type_remarks,
                    'lc' => $request->lc,
                    'lc_date' => $request->lc_date,
                    'delivery_date' => $request->delivery_date,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                    'it_number' => $request->it_number,
                    'it_location_date' => $request->it_location_date,
                    'cprs_number' => $request->cprs_number,
                    'cprs_location_date' => $request->cprs_location_date,
                    'bank_endorsement' => $request->bankEndorsement,
                    'doc_required' => $request->doc_required,
                    'doc_record_By' => $request->doc_record_By,
                    'doc_rcv_date' => $request->doc_rcv_date,
                    'pod_send_by' => $request->pod_send_by,
                    'pod_date' => $request->pod_date,
                    'sub_bl_no' => $request->sub_bl_no,
                    'buyer_id' => $request->buyer_id,
                    'buying_house' => $request->buying_house,
                    'cargo_pickup' => $request->cargo_pickup,
                    'cargo_pickup_date' => $request->cargo_pickup_date,
                    'container_pickup' => $request->container_pickup,
                    'pickup_ref_no' => $request->pickup_ref_no,
                    'cargo_dropoff' => $request->cargo_dropoff,
                    'cargo_dropoff_date' => $request->cargo_dropoff_date,
                    'container_dropoff' => $request->container_dropoff,
                    'dropoff_ref_no' => $request->dropoff_ref_no,
                ]);
            }
            if ((int) $request->operation_id == 3) {
                $job_other_info = AEJobOtherInfo::where('job_master_id', $job_master->id)->update([
                    'job_master_id' => $job_master->id,
                    'agree_rate' => $request->agree_rate,
                    'remarks' => $request->remarks,
                    'document_type_id' => $request->document_type_id,
                    'document_type_remarks' => $request->document_type_remarks,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                ]);
            }
            if ((int) $request->operation_id == 4) {
                $job_other_info = AIJobOtherInfo::where('job_master_id', $job_master->id)->update([
                    'job_master_id' => $job_master->id,
                    'remarks' => $request->remarks,
                    'document_type_remarks' => $request->document_type_remarks,
                    'cargo_type' => $request->cargo_type,
                    'any_other_information' => $request->any_other_information,
                    'cargo_menifest_remarks' => $request->cargo_menifest_remarks,
                    'bank_endorsement' => $request->bankEndorsement,
                    'doc_required' => $request->docRequired,
                    'doc_record_by' => $request->docRecordBy,
                    'doc_rcv_date' => $request->docRcvDate,
                    'pod_send_by' => $request->podSendBy,
                    'pod_date' => $request->podDate,
                    'it_number' => $request->it_number,
                    'it_location_date' => $request->it_location_date,
                    'cprs_number' => $request->cprs_number,
                    'cprs_location_date' => $request->cprs_location_date,
                    'invoice_no' => $request->invoice_no,
                    'invoice_date' => $request->invoice_date,
                    'export_no' => $request->export_no,
                    'export_date' => $request->export_date,
                    'contract_no' => $request->contract_no,
                    'contract_date' => $request->contract_date,
                    'lc' => $request->lc,
                    'lc_date' => $request->lc_date,
                    'req_docs' => $request->req_docs,
                ]);
            }
            // $tabId = $request->input('tabId');
            $innertabId = '';
            $tabId = $request->input('tabId');
            if ($tabId === 'payable') {
                $tabId = 'charges';
                $innertabId = 'payable';
            } else if ($tabId === 'receivable') {
                $tabId = 'charges';
                $innertabId = 'receivable';
            }

            $logController->createLog(__METHOD__, 'success', 'SE JOB Created.', auth()->user(), '');

            if ($job_master->operation_id == 1) {
                return redirect()->to('/se_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Updated SuccessFully!');
            } elseif ($job_master->operation_id == 2) {
                return redirect()->to('/si_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Updated SuccessFully!');
            } elseif ($job_master->operation_id == 3) {
                return redirect()->to('/ae_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Updated SuccessFully!');
            } elseif ($job_master->operation_id == 4) {
                return redirect()->to('/ai_job/edit/' . $job_master->id . "?tab=" . $tabId . "&inner_tab=" . $innertabId)->with('success', 'Record Updated SuccessFully!');
            } else {
                return redirect()->to('/dashboard')->with('success', 'Record Updated SuccessFully!');
            }
            // return redirect()->to('se_job/edit/' . $job_master->id . '?tab=' . $tabId)->with('success', 'Record Updated SuccessFully!');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function updateStatus(JobMaster $job_master, LogsController $logController, Request $request)
    {
        try {

            $job_master->status = 2;
            // $job_master->file_no = $request->hidden_file_no;
            $job_master->save();

            // JobMaster::where('id', $job_master->id)->update([
            //     'file_no' => $request->file_no,
            //     ]);

            $logController->createLog(__METHOD__, 'success', 'JOB Approved.', auth()->user(), '');
            session()->flash('success', 'Job Approved Successfully');
            return redirect()->back()->with('success', 'Job Approved!');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function deletePayable($id, LogsController $logController, Request $request)
    {
        try {
            $job_charges_payable = JobChargesPayable::find($id);
            if (!$job_charges_payable) {
                $logController->createLog(__METHOD__, 'error', 'Payable record not found.', auth()->user(), '');
                return redirect()->back()->with('error', 'Payable record not found!');
            }

            $job_master_id = $job_charges_payable->job_master_id;

            $job_charges_payable->delete();

            // Retrieve the job master
            $job_master = JobMaster::find($job_master_id);
            if (!$job_master) {
                // If job_master doesn't exist, log and return an error
                $logController->createLog(__METHOD__, 'error', 'Job Master not found.', auth()->user(), '');
                return redirect()->back()->with('error', 'Job Master record not found!');
            }

            // Calculate sums for job_charges_receivable
            $sum = JobChargesPayable::where('job_master_id', $job_master_id)
                ->selectRaw('SUM(local_amount) as sum_local_amount, 
                        SUM(CASE WHEN ppcc = "PP" THEN local_amount ELSE 0 END) as sum_pp_local_amount,
                        SUM(CASE WHEN ppcc = "CC" THEN local_amount ELSE 0 END) as sum_cc_local_amount')
                ->first();

            // Calculate required fields
            $principal_net = $job_master->principal_receivable - $sum->sum_local_amount;
            $total_payable = $sum->sum_local_amount - $job_master->tax_total_payable;
            $net = $job_master->total_receivable - $total_payable;

            // Update job master with new values
            $job_master->update([
                'principal_payable' => $sum->sum_local_amount,
                'principal_net' => $principal_net,
                'pp_payable' => $sum->sum_pp_local_amount,
                'cc_payable' => $sum->sum_cc_local_amount,
                'total_payable' => $total_payable,
                'net' => $net,
            ]);

            // Log the success
            $logController->createLog(__METHOD__, 'success', 'Payable Deleted.', auth()->user(), '');

            // Return success message
            return redirect()->back()->with('success', 'Deleted Successfully!');
        } catch (Exception $e) {
            // Log the error
            $logController->createLog(__METHOD__, 'error', $e->getMessage(), auth()->user(), '');

            // Return error message
            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
    // public function deletePayable($id, LogsController $logController, Request $request)
    // {
    //     try {
    //         JobChargesPayable::where('id', $id)->delete();

    //         $logController->createLog(__METHOD__, 'success', 'Payale Deleted.', auth()->user(), '');

    //         return redirect()->back()->with('success', 'Deleted Successfully!');
    //     } catch (Exception $e) {
    //         dd($e);

    //         $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

    //         return redirect()->back()->with('error', 'Something Went Wrong!');
    //     }
    // }

    public function deleteReceivable($id, LogsController $logController, Request $request)
    {
        try {
            // Check if the JobChargesReceivable record exists
            $job_charges_receivable = JobChargesReceivable::find($id);
            if (!$job_charges_receivable) {
                // If not found, log and return an error
                $logController->createLog(__METHOD__, 'error', 'Receivable record not found.', auth()->user(), '');
                return redirect()->back()->with('error', 'Receivable record not found!');
            }

            $job_master_id = $job_charges_receivable->job_master_id;

            // Delete the receivable record
            $job_charges_receivable->delete();

            // Retrieve the job master
            $job_master = JobMaster::find($job_master_id);
            if (!$job_master) {
                // If job_master doesn't exist, log and return an error
                $logController->createLog(__METHOD__, 'error', 'Job Master not found.', auth()->user(), '');
                return redirect()->back()->with('error', 'Job Master record not found!');
            }

            // Calculate sums for job_charges_receivable
            $sum = JobChargesReceivable::where('job_master_id', $job_master_id)
                ->selectRaw('SUM(local_amount) as sum_local_amount, 
                        SUM(CASE WHEN ppcc = "PP" THEN local_amount ELSE 0 END) as sum_pp_local_amount,
                        SUM(CASE WHEN ppcc = "CC" THEN local_amount ELSE 0 END) as sum_cc_local_amount')
                ->first();

            // Calculate required fields
            $principal_net = $sum->sum_local_amount - $job_master->principal_payable;
            $total_receivable = $sum->sum_local_amount - $job_master->tax_total_receivable;
            $net = $total_receivable - $job_master->total_payable;

            // Update job master with new values
            $job_master->update([
                'principal_receivable' => $sum->sum_local_amount,
                'principal_net' => $principal_net,
                'pp_receivable' => $sum->sum_pp_local_amount,
                'cc_receivable' => $sum->sum_cc_local_amount,
                'total_receivable' => $total_receivable,
                'net' => $net,
            ]);

            // Log the success
            $logController->createLog(__METHOD__, 'success', 'Receivable Deleted.', auth()->user(), '');

            // Return success message
            return redirect()->back()->with('success', 'Deleted Successfully!');
        } catch (Exception $e) {
            // Log the error
            $logController->createLog(__METHOD__, 'error', $e->getMessage(), auth()->user(), '');

            // Return error message
            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }


    public function unapproveJob(JobMaster $job_master, LogsController $logController)
    {
        try {
            $job_receivables = JobChargesReceivable::where('job_master_id', $job_master->id)->get();
            $job_payables = JobChargesPayable::where('job_master_id', $job_master->id)->get();

            $hasNonNullBillInvoice = false;

            foreach ($job_receivables as $receivable) {
                if ($receivable->bill_invoice !== null) {
                    $hasNonNullBillInvoice = true;
                    break;
                }
            }

            foreach ($job_payables as $payable) {
                if ($payable->bill_invoice !== null) {
                    $hasNonNullBillInvoice = true;
                    break;
                }
            }
            // dd($hasNonNullBillInvoice);

            if (!$hasNonNullBillInvoice) {
                // dd('in if');
                $job_master->status = 1;
                $job_master->save();

                foreach ($job_master->job_charges_payable as $payable) {
                    $payable->status = 1;
                    $payable->approved_by = null;
                    $payable->approved_date = null;
                    $payable->approval_log = null;
                    $payable->approved = 0;
                    $payable->save();
                }

                foreach ($job_master->job_charges_receivable as $receivable) {
                    $receivable->status = 1;
                    $receivable->approved_by = null;
                    $receivable->approved_date = null;
                    $receivable->approval_log = null;
                    $receivable->approved = 0;
                    $receivable->save();
                }

                $logController->createLog(__METHOD__, 'success', 'JOB Unapproved.', auth()->user(), '');
                session()->flash('success', 'Job Unapproved Successfully');
                return redirect()->back();
            } else {
                // dd('in else');
                $logController->createLog(__METHOD__, 'error', 'Invoice Exist.', auth()->user(), '');
                session()->flash('error', 'Invoices Exist');
                return redirect()->back();
            }
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function updateStatusCharges(JobMaster $job_master, LogsController $logController, Request $request)
    {
        try {
            // Retrieve and validate the request parameters
            $job_receivable_ids = $request->input('job_receievable_charges_ids', []);
            $job_payable_ids = $request->input('job_payable_charges_ids', []);

            // Ensure they are arrays
            if (is_string($job_receivable_ids)) {
                $job_receivable_ids = explode(',', $job_receivable_ids);
            }

            if (is_string($job_payable_ids)) {
                $job_payable_ids = explode(',', $job_payable_ids);
            }

            // Remove any empty values that might have been introduced
            $job_receivable_ids = array_filter($job_receivable_ids);
            $job_payable_ids = array_filter($job_payable_ids);

            // Fetch the records using whereIn only if IDs are not empty
            $job_receivables = collect();
            if (!empty($job_receivable_ids)) {
                $job_receivables = JobChargesReceivable::whereIn('id', $job_receivable_ids)
                    ->where('status', '!=', 2) // Only get records where status is not 2
                    ->get();
            }

            $job_payables = collect();
            if (!empty($job_payable_ids)) {
                $job_payables = JobChargesPayable::whereIn('id', $job_payable_ids)
                    ->where('status', '!=', 2) // Only get records where status is not 2
                    ->get();
            }

            // Debugging output
            // dd($job_receievables, $job_payables);

            // Check if receivable_customer_id is present for receivables
            foreach ($job_receivables as $job_receivable) {
                // dd($job_receivable->customer_id);
                if (is_null($job_receivable->customer_id)) {
                    session()->flash('error', 'Customer does not exist for receivable charge');
                    return response()->json(['data' => 'Customer does not exist for receivable charges', 'status' => 400], 400);
                }
            }

            // Check if payable_vendor_id is present for payables
            foreach ($job_payables as $job_payable) {
                if (is_null($job_payable->vendor_id)) {
                    session()->flash('error', 'Vendor does not exist for payable charge');
                    return response()->json(['data' => 'Vendor does not exist for payable charges', 'status' => 400], 400);
                }
            }


            foreach ($job_payables as $job_payable) {
                JobChargesPayable::where('id', $job_payable->id)->update([
                    'status' => 2,
                    'approved_by' => auth()->user()->id,
                    'approved_date' => Carbon::now(),
                    'approval_log' => Carbon::now(),
                    'approved' => 1,
                ]);
            }

            foreach ($job_receivables as $job_receievable) {
                JobChargesReceivable::where('id', $job_receievable->id)->update([
                    'status' => 2,
                    'approved_by' => auth()->user()->id,
                    'approved_date' => Carbon::now(),
                    'approval_log' => Carbon::now(),
                    'approved' => 1,
                ]);
            }


            $logController->createLog(__METHOD__, 'success', 'Charge Approved.', auth()->user(), '');

            // return redirect()->back()->with('success', 'Charges Approved!');
            session()->flash('success', 'Charges Approved Successfully');
            return response()->json(['data' => 'Data Saved!', 'status' => 200], 200);
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            // return redirect()->back()->with('error', 'Something Went Wrong!');
            return response()->json(['data' => $e, 'status' => 500], 500);
        }
    }
    public function unapproveCharges(JobMaster $job_master, LogsController $logController, Request $request)
    {
        try {

            $job_receivable_ids = $request->input('job_receievable_charges_ids', []);
            $job_payable_ids = $request->input('job_payable_charges_ids', []);

            // Ensure they are arrays
            if (is_string($job_receivable_ids)) {
                $job_receivable_ids = explode(',', $job_receivable_ids);
            }

            if (is_string($job_payable_ids)) {
                $job_payable_ids = explode(',', $job_payable_ids);
            }

            // Remove any empty values that might have been introduced
            $job_receivable_ids = array_filter($job_receivable_ids);
            $job_payable_ids = array_filter($job_payable_ids);

            // Fetch the records using whereIn only if IDs are not empty
            $job_receivables = collect();
            if (!empty($job_receivable_ids)) {
                $job_receivables = JobChargesReceivable::whereIn('id', $job_receivable_ids)
                    ->whereNull('bill_invoice') // Only get records where bill_invoice is null
                    ->get();
            }

            $job_payables = collect();
            if (!empty($job_payable_ids)) {
                $job_payables = JobChargesPayable::whereIn('id', $job_payable_ids)
                    ->whereNull('bill_invoice') // Only get records where bill_invoice is null
                    ->get();
            }

            // $job_receievables = JobChargesReceivable::where('id', $request->job_receievable_charges_ids)->get();
            // $job_payables = JobChargesPayable::where('id', $request->job_payable_charges_ids)->get();

            foreach ($job_payables as $job_payable) {
                JobChargesPayable::where('id', $job_payable->id)->update([
                    'status' => 1,
                    'approved_by' => null,
                    'approved_date' => null,
                    'approval_log' => null,
                    'approved' => 0,
                ]);
            }

            foreach ($job_receivables as $job_receievable) {
                JobChargesReceivable::where('id', $job_receievable->id)->update([
                    'status' => 1,
                    'approved_by' => null,
                    'approved_date' => null,
                    'approval_log' => null,
                    'approved' => 0,
                ]);
            }

            $logController->createLog(__METHOD__, 'success', 'Charge Unapproved.', auth()->user(), '');
            session()->flash('success', 'Charge Unapproved Successfully');
            return redirect()->back()->with('success', 'Charge Unapproved!');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }


    public function print(JobMaster $job_master, LogsController $logController, Request $request)
    {
        try {
            // dd($request->all());
            $logController->createLog(__METHOD__, 'success', 'JOB Print.', auth()->user(), '');

            $job_master = JobMaster::with(['job_detail', 'job_vessel', 'job_weight', 'job_equipments', 'job_charges_receivable', 'job_charges_receivable.charge', 'job_charges_receivable.customer', 'job_charges_receivable.transaction_charges', 'job_charges_payable', 'job_charges_payable.vendor', 'job_charges_payable.charge', 'job_charges', 'job_routing', 'job_other_info'])->where('id', $job_master->id)->first();
            $bl_master = BlMaster::where('job_master_id', $job_master->id)->first();
            $bl_container_info = $bl_master ? BLContainerInfo::where('bl_master_id', $bl_master->id)->first() : null;
            $containerNo = '';

            if ($bl_master && $bl_master->bl_container_info) {
                foreach ($bl_master->bl_container_info as $container) {
                    $containerNo = $bl_master->bl_container_info->pluck('container_no')->implode(', ');
                }
            }
            // dd($job_master);
            $format = $request->format;
            $show_charges = $request->show_charges;
            $print_company_header = $request->print_company_header;

            $customer_id = $request->customer_id;
            $customer = Party::where('id', $customer_id)->first();
            $show_bank = $request->show_bank;
            $add_discription_with_charges = $request->add_discription_with_charges;
            $add_discription_only = $request->add_discription_only;
            $only_ocean_freight_charges = $request->only_ocean_freight_charges;
            $exclude_ocean_freight = $request->exclude_ocean_freight;
            $print_only_unapproved_charges = $request->print_only_unapproved_charges;
            $show_container = $request->show_container;

            if ($request->reportOptions == 'booking_status') {
                return view('sea_export.se_job.pdf.booking_status_pdf', compact('job_master', 'containerNo', 'format', 'show_charges', 'print_company_header'));
            } else if ($request->reportOptions == 'console_pnl_sheet') {
                return view('sea_export.se_job.pdf.console_pnl_sheet_pdf', compact('job_master', 'containerNo'));
            } else if ($request->reportOptions == 'proforma_invoice') {
                return view('sea_export.se_job.pdf.proforma_invoice_pdf', compact('job_master', 'containerNo', 'customer_id', 'show_bank', 'add_discription_with_charges', 'add_discription_only', 'only_ocean_freight_charges', 'exclude_ocean_freight', 'print_only_unapproved_charges', 'show_container', 'customer'));
            }
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function getRecCharges($jobId, $customerId, Request $request)
    {
        $job_receivables = JobChargesReceivable::with(['charge', 'customer', 'approved_by_name', 'job_master', 'transaction_charges', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->where('customer_id', $customerId)
            ->whereIn('id', explode(',', $request->charges_ids))
            ->where('ppcc', '!=', 'CC')
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_receivables' => $job_receivables]);
    }

    public function getRecChargeDetail($jobId, $customerId, $chargeId)
    {
        $job_receivables = JobChargesReceivable::with(['charge', 'customer', 'approved_by_name', 'job_master', 'transaction_charges', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->where('customer_id', $customerId)
            ->where('charge_id', $chargeId)
            ->where('ppcc', '!=', 'CC')
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_receivables' => $job_receivables]);
    }

    public function getRecCCCharges($jobId, $customerId, Request $request)
    {
        $job_receivables = JobChargesReceivable::with(['charge', 'customer', 'approved_by_name', 'job_master', 'transaction_charges', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->whereIn('id', explode(',', $request->charges_ids))
            ->where('customer_id', $customerId)
            ->where('ppcc', '!=', 'PP')
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_receivables' => $job_receivables]);
    }

    public function getRecCCChargeDetail($jobId, $customerId, $chargeId)
    {
        $job_receivables = JobChargesReceivable::with(['charge', 'customer', 'approved_by_name', 'job_master', 'transaction_charges', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->where('customer_id', $customerId)
            ->where('charge_id', $chargeId)
            ->where('ppcc', '!=', 'PP')
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_receivables' => $job_receivables]);
    }

    public function getPayCharges($jobId, $vendorId, Request $request)
    {
        $job_payables = JobChargesPayable::with(['charge', 'vendor', 'approved_by_name', 'job_master', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->whereIn('id', explode(',', $request->charges_ids))
            ->where('vendor_id', $vendorId)
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_payables' => $job_payables]);
    }

    public function getPayChargeDetail($jobId, $vendorId, $chargeId)
    {
        $job_payables = JobChargesPayable::with(['charge', 'vendor', 'approved_by_name', 'job_master', 'currency_name'])
            ->where('job_master_id', $jobId)
            ->whereNull('bill_invoice')
            ->where('vendor_id', $vendorId)
            ->where('charge_id', $chargeId)
            ->get();

        // $job_receivables = JobChargesReceivable::where('job_master_id', $jobId)->where('customer_id', $customerId)->get();
        return response()->json(['job_payables' => $job_payables]);
    }
}