<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\City;
use App\Models\Country;
use App\Models\JobMaster;
use App\Models\PartyLocations;
use App\Models\Vessel;


class SEManifestController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        return view('sea_export.se_manifest.index');
    }

    public function add(JobMaster $job_master)
    {
        $vessels = Vessel::where('status', 1)->get();
        $party_locations = PartyLocations::where('status', 1)->get();
        return view('sea_export.se_manifest.add', compact('vessels', 'party_locations', 'job_master'));
    }
}
