<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\City;
use App\Models\Country;
use App\Models\Vessel;
use App\Models\Voyage;

class SEMilestoneController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        return view('sea_export.se_milestone.index');
    }

    public function add()
    {
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        return view('sea_export.se_milestone.add' , compact('vessels','voyages'));
    }
}
