<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\Bills;
use App\Models\ChartOfAccounts;
use App\Models\City;
use App\Models\CostCenter;
use App\Models\Country;
use App\Models\Operations;
use App\Models\Party;
use App\Models\ReceiptPayments;
use App\Models\ReceiptPaymentsDetail;
use App\Models\TransactionDetail;
use App\Models\TransactionMaster;
use App\Models\Transactions;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SEReceiptController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index(Request $request)
    {
        $url = $request->getRequestUri();


        if ($url == "/receipt" || $request->is('receipt')) {
            // dd('Receipt Payment Index');
            $transaction_numbers = ReceiptPayments::pluck('trans_no');
            $operations = Operations::all();
            $accounts = ChartOfAccounts::where('sub_category_id', 1)->orWhere('sub_category_id', 2)->get();
            $clients = Party::all();

            // Start query builder
            $query = ReceiptPayments::query();

            if ($request->filled('client_id')) {
                $query->where('client_id', $request->client_id);
            }

            if ($request->filled('account_id')) {
                $query->where('account_id', $request->account_id);
            }

            if ($request->filled('trans_no')) {
                $query->where('trans_no', $request->trans_no);
            }

            if ($request->filled('date_from')) {
                $query->whereDate('created_at', '>=', $request->date_from);
            }

            if ($request->filled('date_to')) {
                $query->whereDate('created_at', '<=', $request->date_to);
            }

            if ($request->filled('operation_id')) {
                $query->where('operation_id', $request->operation_id);
            }

            if ($request->filled('type')) {
                $query->where('type', $request->type);
            }

            // Execute filtered query
            $receipt_payment = $query->get();
            return view('receipt_payment.index', compact('receipt_payment', 'transaction_numbers', 'operations', 'accounts', 'clients'));
        } else if ($url == "/se_receipt") {
            $receipt_payment = ReceiptPayments::where('operation_id', 1)->get();
            return view('sea_export.se_receipt.index', compact('receipt_payment'));
        } else if ($url == "/si_receipt") {
            $receipt_payment = ReceiptPayments::where('operation_id', 2)->get();
            return view('sea_export.se_receipt.index', compact('receipt_payment'));
        } else if ($url == "/ae_receipt") {
            $receipt_payment = ReceiptPayments::where('operation_id', 3)->get();
            return view('sea_export.se_receipt.index', compact('receipt_payment'));
        } else if ($url == "/ai_receipt") {
            $receipt_payment = ReceiptPayments::where('operation_id', 4)->get();
            return view('sea_export.se_receipt.index', compact('receipt_payment'));
        }
    }

    public function add(Request $request)
    {
        $transaction_id = $request->transaction_id;
        $bill_id = $request->bill_id;
        $transaction = null;
        if (!empty($transaction_id)) {
            $transaction = Transactions::find($transaction_id);
        } else if (!empty($bill_id)) {
            $transaction = Bills::find($bill_id);
        }
        // dd($transaction);
        // $accounts = ChartOfAccounts::where('sub_category_id', 1)->orWhere('sub_category_id', 2)->get();
        $cost_centers = CostCenter::where('status', 1)->get();
        $transaction_no = ReceiptPayments::max('id');
        $operations = Operations::all();

        return view('sea_export.se_receipt.add', compact( 'cost_centers', 'transaction_no', 'operations', 'transaction'));
    }


    public function store(Request $request, LogsController $logController)
    {

        try {
            // dd($request->all());
            $operation_id = $request->operation_id;
            if ($operation_id == 'all') {
                $operation_id = null;
            }

            $party_id = ChartOfAccounts::where('party_id', $request->client_id)->first();

            if (!$party_id) {
                return redirect()->back()->with('error', 'No Chart of Account found for this client.');
            }
            // dd($operation_id);

            $receipt_payment = ReceiptPayments::create([
                'type' => $request->type,
                'trans_no' => $request->tran_no,
                'operation_id' => $operation_id,
                'trans_date' => $request->tran_date,
                'advance_bal' => $request->advance_bal,
                'cost_center' => $request->cost_center_id,
                'client_id' => $request->client_id,
                'account_type' => $request->account_type,
                'account_id' => $request->account_id,
                'terminal_inv' => $request->terminal_inv_no,
                'nature' => $request->nature,
                'cheque_number' => $request->cheque_number,
                'cheque_date' => $request->cheque_date,
                'date' => $request->date,
                'ref_no' => $request->ref_no,
                'total_received_amount' => $request->total_receiving_amount,
                'currency' => $request->currency,
                'exchange_rate' => $request->exchange_rate,
                'tax' => $request->tax,
                'tax_amount' => $request->tax_amt,
                'invoice_no' => $request->invoice_no,
                'bank_charges' => $request->bank_charges,
                'gain_loss' => $request->gain_loss,
                'remarks' => $request->remarks,
                'total_amount' => $request->total_amount,
                'advance' => $request->advance,
                'net_received' => $request->net_received,
                'total_amount_conv' => $request->total_amount_conv,
                'voucher_no' => $request->voucher_no,
                'ref' => $request->rf,
                'normal' => $request->normal,
                'security' => $request->security,
                'detention' => $request->detention,
                'status' => $request->status,
                'created_by' => auth()->user()->id ?? 1,
                'updated_by' => auth()->user()->id ?? 1,
            ]);

            if ($request->invoice_id) {
                for ($i = 0; $i < count($request->invoice_id); $i++) {
                    // $balance = (int) $request->balance[$i];
                    if ($request->rcvd_amount[$i] != 0 && $request->rcvd_amount[$i] != '-') {
                        $net_amount = (float) $request->grand_total_amount[$i] - (float) $request->rcvd_converted_amount[$i];
                        ReceiptPaymentsDetail::create([
                            'invoice_id' => $request->invoice_id[$i],
                            'receipt_payment_id' => $receipt_payment->id,
                            'job_no' => $request->job_master_id[$i],
                            'invoice_no' => $request->invoice_tran_no[$i],
                            'ref_no' => $request->ref_tran_no[$i],
                            'hbl_no' => $request->hbl_no[$i],
                            'mbl_no' => $request->mbl_no[$i],
                            'inv_curr' => $request->inv_curr[$i],
                            'rcvd_amount' => $request->rcvd_amount[$i],
                            'rcvd_converted_amount' => $request->rcvd_converted_amount[$i],
                            'invoice_amount' => $request->grand_total_amount[$i],
                            'balance' => $request->balance[$i],
                            'file_no' => $request->file_no[$i],
                            'container_no' => $request->container[$i],
                            'created_by' => auth()->user()->id ?? 1,
                            'updated_by' => auth()->user()->id ?? 1,
                        ]);

                        if ($request->type == "receipt") {
                            if ($net_amount == 0) {
                                Transactions::where('id', $request->invoice_id[$i])->update([
                                    'status' => 2
                                ]);
                            }
                        }

                        if ($request->type == "payment") {
                            if ($net_amount == 0) {
                                Bills::where('id', $request->invoice_id[$i])->update([
                                    'status' => 2
                                ]);
                            }
                        }
                    }
                    if (($request->rcvd_amount[$i] == 0 || $request->rcvd_amount[$i] == '0.00') && ($request->balance[$i] == 0 || $request->balance[$i] == '0.00')) {
                        if ($request->type == "receipt") {
                            Transactions::where('id', $request->invoice_id[$i])->update([
                                'status' => 2
                            ]);
                        } else {
                            Bills::where('id', $request->invoice_id[$i])->update([
                                'status' => 2
                            ]);
                        }
                    }
                }
            }
            // if ($request->net_received > 0) {
            if ($request->type == 'receipt') {
                $transaction_master = TransactionMaster::create([
                    'receipt_payment_id' => $receipt_payment->id,
                    // 'voucher_no' => 'BRV-' . (int) $request->tran_no . '/' . date('y'),
                    'date' => date('Y-m-d'),
                    'transaction_type_master_id' => 4,
                    'account_id' => $request->account_id, // Credit
                    'cost_center_id' => 1,
                    'party_id' => $party_id->id,
                    'currency_id' => $request->currency,
                    'exchange_rate' => $request->exchange_rate,
                    // 'cheque_date' => $request->cheque_date,
                    'total_debit' => $request->net_received,
                    'total_credit' => $request->net_received,
                    'total_debit_converted' => $request->total_amount_conv,
                    'total_credit_converted' => $request->total_amount_conv,
                    // 'bank_sub_type' => $request->bank_sub_type,
                    'company_id' => 1,
                    'status' => 1,
                    'narration' => $request->remarks,
                    'created_by' => auth()->user()->id,
                    'voucher_type_id' => 2
                ]);

                // Debit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $request->account_id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => $request->net_received,
                    'credit_vc' => 0,
                    'debit_lc' => $request->total_amount_conv,
                    'credit_lc' => 0,
                    'narration' => $request->remarks,
                    'status' => 1
                ]);

                // Credit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $party_id->id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => 0,
                    'credit_vc' => $request->net_received,
                    'debit_lc' => 0,
                    'credit_lc' => $request->total_amount_conv,
                    'narration' => $request->remarks,
                    'status' => 1
                ]);
            } else {
                $transaction_master = TransactionMaster::create([
                    'receipt_payment_id' => $receipt_payment->id,
                    // 'voucher_no' => 'BPV-' . (int) $request->tran_no . '/' . date('y'),
                    'date' => date('Y-m-d'),
                    'transaction_type_master_id' => 4,
                    'account_id' => $request->account_id, // Credit
                    'cost_center_id' => 1,
                    'party_id' => $party_id->id,
                    'currency_id' => $request->currency,
                    'exchange_rate' => $request->exchange_rate,
                    // 'cheque_date' => $request->cheque_date,
                    'total_debit' => $request->net_received,
                    'total_credit' => $request->net_received,
                    'total_debit_converted' => $request->total_amount_conv,
                    'total_credit_converted' => $request->total_amount_conv,
                    // 'bank_sub_type' => $request->bank_sub_type,
                    'company_id' => 1,
                    'status' => 1,
                    'narration' => $request->remarks,
                    'created_by' => auth()->user()->id,
                    'voucher_type_id' => 1
                ]);

                // Debit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $party_id->id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => $request->net_received,
                    'credit_vc' => 0,
                    'debit_lc' => $request->total_amount_conv,
                    'credit_lc' => 0,
                    'narration' => $request->remarks,
                    'status' => 1
                ]);

                // Credit
                TransactionDetail::create([
                    'transaction_master_id' => $transaction_master->id,
                    'account_id' => $request->account_id,
                    // 'cost_center_id' => $request->cost_center_detail[$key],
                    'debit_vc' => 0,
                    'credit_vc' => $request->net_received,
                    'debit_lc' => 0,
                    'credit_lc' => $request->total_amount_conv,
                    'narration' => $request->remarks,
                    'status' => 1
                ]);
            }
            // }

            $remarks = $request->remarks;
            $type = $request->type;
            $nature = $request->nature;

            $currencyMap = [
                1 => "PKR",
                2 => "USD",
                3 => "AED",
                4 => "GPB",
                5 => "EUR",
                6 => "BDT",
                7 => "OMR",
            ];

            $currency = $currencyMap[$request->currency] ?? "PKR";

            if ($remarks === null) {
                $partyName = $receipt_payment->party->name ?? '';
                $fromOrTo = $type === 'receipt' ? 'From' : 'To';
                $receivedOrPaid = $type === 'receipt' ? 'Received' : 'Paid';

                $via = $type === 'receipt' ? [
                    'Cash' => 'Received Cash',
                    'Cheque' => 'Received Cheque',
                    'Pay Order' => 'Received Pay Order',
                    'TT' => 'Received TT',
                    'Credit Card' => 'Credit Card Payment',
                    'Online Transfer' => 'Online Transferred',
                ] : [
                    'Cash' => 'Paid Cash',
                    'Cheque' => 'Paid via Cheque',
                    'Pay Order' => 'Paid via Pay Order',
                    'TT' => 'Paid via TT',
                    'Credit Card' => 'Credit Card Payment',
                    'Online Transfer' => 'Online Transfer',
                ];

                $remarksTypeText = $via[$nature] ?? ($receivedOrPaid . " Amount");

                $commonDetails = function ($key) use ($request) {
                    return ($request->invoice_tran_no[$key] ?? '-') . " / " .
                        ($request->hbl_no[$key] ?? '-') . " / " .
                        ($request->mbl_no[$key] ?? '-') . " / " .
                        ($request->job_no[$key] ?? '-') . " / " .
                        ($request->file_no[$key] ?? '-') . " / " .
                        ($request->ref_tran_no[$key] ?? '-') .
                        " ( PKR " . ($request->rcvd_converted_amount[$key] ?? '0') . " )";
                };

                if (!empty($request->invoice_id) && is_array($request->invoice_id)) {
                    foreach ($request->invoice_id as $key => $value) {
                        if (!empty($request->rcvd_amount[$key]) && $request->rcvd_amount[$key] != 0 && $request->rcvd_amount[$key] != '-') {
                            if ($nature === 'Cheque') {
                                $remarks .= "$remarksTypeText # " . ($request->cheque_number ?? '-') . " Dated " . ($request->cheque_date ?? '-') . " Against Inv/HBL/MBL/Job No(s)/File No/Reference No/Vehicle No: ";
                            } else {
                                $remarks .= "$remarksTypeText Against Inv/HBL/MBL/Job No(s)/File No/Reference No/Vehicle No: ";
                            }
                            $remarks .= $commonDetails($key) . ", ";
                        }
                    }
                    $remarks = rtrim($remarks, ', ') . " $fromOrTo " . $partyName;
                } else {
                    if ($nature === 'Cheque') {
                        $remarks = "$remarksTypeText # " . ($request->cheque_number ?? '-') . " Dated " . ($request->cheque_date ?? '-') . " Against Advance ( $currency " . ($request->advance ?? '0') . " ) $fromOrTo " . $partyName;
                    } else {
                        $remarks = "$remarksTypeText Against Advance ( $currency " . ($request->advance ?? '0') . " ) $fromOrTo " . $partyName;
                    }
                }

                // Save the final remarks
                $receipt_payment->remarks = $remarks;
                $transaction_master->narration = $remarks;
                TransactionDetail::where('transaction_master_id', $transaction_master->id)->update([
                    'narration' => $remarks
                ]);
                $receipt_payment->save();
            }

            $logController->createLog(__METHOD__, 'success', $receipt_payment, auth()->user(), '');

            $url = $request->getRequestUri();

            if ($url == "/receipt/add") {
                return redirect()->to('/receipt/edit/' . $receipt_payment->id)->with('success', 'Record Created SuccessFully!');
            } else if ($url == "/se_receipt/add") {
                return redirect()->to('/se_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Created SuccessFully!');
            } else if ($url == "/si_receipt/add") {
                return redirect()->to('/si_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Created SuccessFully!');
            } else if ($url == "/ae_receipt/add") {
                return redirect()->to('/ae_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Created SuccessFully!');
            } else if ($url == "/ai_receipt/add") {
                return redirect()->to('/ae_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Created SuccessFully!');
            }

            // return redirect()->back()->with('success', 'New Record Created Successfully!');

        } catch (Exception $e) {
            // dd($e);
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit(ReceiptPayments $receipt_payment)
    {
        // $accounts = ChartOfAccounts::where('sub_category_id', 1)->orWhere('sub_category_id', 2)->get();
        if ($receipt_payment->account_type == 'Cash') {
            $accounts = ChartOfAccounts::where('sub_category_id', 1)->get();
        } else if ($receipt_payment->account_type == 'Bank') {
            $accounts = ChartOfAccounts::where('sub_category_id', 2)->get();
        } else if ($receipt_payment->account_type == 'Adjustment') {
            $accounts = ChartOfAccounts::whereNotIn('sub_category_id', [1, 2])->get();
        } else {
            $accounts = ChartOfAccounts::where('id', $receipt_payment->account_id)->get();
        }
        $cost_centers = CostCenter::where('status', 1)->get();
        $transaction_no = ReceiptPayments::max('id');
        $receipt_payment_detail = ReceiptPaymentsDetail::where('receipt_payment_id', $receipt_payment->id)->get();
        $transaction_master = TransactionMaster::where('receipt_payment_id', $receipt_payment->id)->first();
        // dd($receipt_payment);
        $clients = [];
        if ($receipt_payment->type == 'receipt') {
            $clients = Party::where('party_is', 'customer')->orWhere('party_is', 'customer_vendor')->get();
        } else if ($receipt_payment->type == 'payment') {
            $clients = Party::where('party_is', 'vendor')->orWhere('party_is', 'customer_vendor')->get();
        }
        ;
        $operations = Operations::all();

        // dd($receipt_payment_detail);

        return view('sea_export.se_receipt.edit', compact('accounts', 'receipt_payment', 'operations', 'receipt_payment_detail', 'transaction_master', 'clients', 'cost_centers', 'transaction_no'));
    }

    public function update(ReceiptPayments $receipt_payment, Request $request, LogsController $logController)
    {
        // dd($request->all());
        try {

            if ($receipt_payment->transaction->status == 4) {
                return redirect()->back()->with('error', 'Cannot update a voucher that has been posted.');
            } else {
                $operation_id = $request->operation_id;
                if ($operation_id == 'all') {
                    $operation_id = null;
                }
                $party_id = ChartOfAccounts::where('party_id', $request->client_id)->first();

                if (!$party_id) {
                    return redirect()->back()->with('error', 'No Chart of Account found for this client.');
                }

                ReceiptPayments::where('id', $receipt_payment->id)->update([
                    // 'type' => $request->type,
                    'trans_no' => $request->tran_no,
                    'operation_id' => $operation_id,
                    'trans_date' => $request->tran_date,
                    'advance_bal' => $request->advance_bal,
                    'cost_center' => $request->cost_center_id,
                    'client_id' => $request->client_id,
                    'account_type' => $request->account_type,
                    'account_id' => $request->account_id,
                    'terminal_inv' => $request->terminal_inv_no,
                    'nature' => $request->nature,
                    'cheque_number' => $request->cheque_number,
                    'cheque_date' => $request->cheque_date,
                    'date' => $request->date,
                    'ref_no' => $request->ref_no,
                    'total_received_amount' => $request->total_receiving_amount,
                    'currency' => $request->currency,
                    'exchange_rate' => $request->exchange_rate,
                    'tax' => $request->tax,
                    'tax_amount' => $request->tax_amt,
                    'invoice_no' => $request->invoice_no,
                    'bank_charges' => $request->bank_charges,
                    'gain_loss' => $request->gain_loss,
                    'remarks' => $request->remarks,
                    'total_amount' => $request->total_amount,
                    'advance' => $request->advance,
                    'net_received' => $request->net_received,
                    'total_amount_conv' => $request->total_amount_conv,
                    'voucher_no' => $request->voucher_no,
                    'ref' => $request->rf,
                    'normal' => $request->normal,
                    'security' => $request->security,
                    'detention' => $request->detention,
                    'status' => $request->status,
                    'updated_by' => auth()->user()->id ?? 1,
                ]);

                if (isset($request['invoice_tran_no']) && count($request['invoice_tran_no']) > 0) {
                    ReceiptPaymentsDetail::where('receipt_payment_id', $receipt_payment->id)->delete();
                    $loop_index = count($request['invoice_tran_no']);

                    // dd($request->all());
                    for ($i = 0; $i < count($request->invoice_id); $i++) {

                        $rcvd_amount = $request->rcvd_amount[$i] ?? 0;
                        $grand_total_amount = $request->grand_total_amount[$i] ?? 0;
                        $rcvd_converted_amount = $request->rcvd_converted_amount[$i] ?? 0;
                        $balance = $request->balance[$i] ?? 0;

                        // for ($i = 0; $i < $loop_index; $i++) {
                        if ($rcvd_amount && $rcvd_amount != 0 && $rcvd_amount != '-' && $rcvd_amount != '0.00') {

                            // $net_amount = $request->grand_total_amount[$i] - $request->rcvd_amount[$i];
                            $net_amount = (float) $grand_total_amount - (float) $rcvd_converted_amount;
                            ReceiptPaymentsDetail::create([
                                'invoice_id' => $request->invoice_id[$i] ?? null,
                                'receipt_payment_id' => $receipt_payment->id,
                                'job_no' => $request->job_master_id[$i] ?? null,
                                'invoice_no' => $request->invoice_tran_no[$i] ?? null,
                                'ref_no' => $request->ref_tran_no[$i] ?? null,
                                'hbl_no' => $request->hbl_no[$i] ?? null,
                                'mbl_no' => $request->mbl_no[$i] ?? null,
                                'inv_curr' => $request->inv_curr[$i] ?? null,
                                'rcvd_amount' => $request->rcvd_amount[$i] ?? null,
                                'rcvd_converted_amount' => $request->rcvd_converted_amount[$i] ?? null,
                                'invoice_amount' => $request->grand_total_amount[$i] ?? null,
                                'balance' => $request->balance[$i] ?? null,
                                'file_no' => $request->file_no[$i] ?? null,
                                'container_no' => $request->container[$i] ?? null,
                                'updated_by' => auth()->user()->id ?? 1,
                            ]);

                            if ($request->type == "receipt" || $request->type == "Receipt") {
                                if ($net_amount == 0) {
                                    Transactions::where('id', $request->invoice_id[$i])->update([
                                        'status' => 2
                                    ]);
                                }
                            }

                            if ($request->type == "payment" || $request->type == "Payment") {
                                if ($net_amount == 0) {
                                    Bills::where('id', $request->invoice_id[$i])->update([
                                        'status' => 2
                                    ]);
                                }
                            }
                        }
                        $rcvd_amount = null;
                        $grand_total_amount = null;
                        $rcvd_converted_amount = null;
                        $balance = null;

                    }
                }

                $transaction_master = TransactionMaster::where('receipt_payment_id', $receipt_payment->id)->first();
                if ($receipt_payment->transaction->status != 4) {
                    $voucher_number = null;
                } else {
                    $voucher_number = $transaction_master->voucher_no;
                }
                $transaction_master->update([
                    // 'receipt_payment_id' => $receipt_payment->id,
                    'voucher_no' => $voucher_number,
                    // 'date' => date('Y-m-d'),
                    'transaction_type_master_id' => 4,
                    'account_id' => $request->account_id, // Credit
                    'cost_center_id' => 1,
                    'party_id' => $party_id->id,
                    'currency_id' => $request->currency,
                    'exchange_rate' => $request->exchange_rate,
                    // 'cheque_date' => $request->cheque_date,
                    'total_debit' => $request->net_received,
                    'total_credit' => $request->net_received,
                    'total_debit_converted' => $request->total_amount_conv,
                    'total_credit_converted' => $request->total_amount_conv,
                    // 'bank_sub_type' => $request->bank_sub_type,
                    'company_id' => 1,
                    // 'status' => 1,
                    'narration' => $request->remarks,
                    'updated_by' => auth()->user()->id,
                    // 'voucher_type_id' => 2
                ]);
                TransactionDetail::where('transaction_master_id', $transaction_master->id)->delete();

                if ($receipt_payment->type == 'receipt') {
                    // Debit
                    TransactionDetail::create([
                        'transaction_master_id' => $transaction_master->id,
                        'account_id' => $request->account_id,
                        // 'cost_center_id' => $request->cost_center_detail[$key],
                        'debit_vc' => $request->net_received,
                        'credit_vc' => 0,
                        'debit_lc' => $request->total_amount_conv,
                        'credit_lc' => 0,
                        'narration' => $request->remarks,
                        'status' => 1
                    ]);

                    // Credit
                    TransactionDetail::create([
                        'transaction_master_id' => $transaction_master->id,
                        'account_id' => $party_id->id,
                        // 'cost_center_id' => $request->cost_center_detail[$key],
                        'debit_vc' => 0,
                        'credit_vc' => $request->net_received,
                        'debit_lc' => 0,
                        'credit_lc' => $request->total_amount_conv,
                        'narration' => $request->remarks,
                        'status' => 1
                    ]);
                } else {
                    TransactionDetail::create([
                        'transaction_master_id' => $transaction_master->id,
                        'account_id' => $party_id->id,
                        // 'cost_center_id' => $request->cost_center_detail[$key],
                        'debit_vc' => $request->net_received,
                        'credit_vc' => 0,
                        'debit_lc' => $request->total_amount_conv,
                        'credit_lc' => 0,
                        'narration' => $request->remarks,
                        'status' => 1
                    ]);

                    // Credit
                    TransactionDetail::create([
                        'transaction_master_id' => $transaction_master->id,
                        'account_id' => $request->account_id,
                        // 'cost_center_id' => $request->cost_center_detail[$key],
                        'debit_vc' => 0,
                        'credit_vc' => $request->net_received,
                        'debit_lc' => 0,
                        'credit_lc' => $request->total_amount_conv,
                        'narration' => $request->remarks,
                        'status' => 1
                    ]);
                }
                // dd($request->client_id);

                // if ($request->type == 'receipt') {
                //     $transaction_master_old = TransactionMaster::where('receipt_payment_id', $receipt_payment->id)->first();
                //     if ($transaction_master_old) {
                //         // Delete related transaction details
                //         TransactionDetail::where('transaction_master_id', $transaction_master_old->id)->delete();
                //         // Delete the master record
                //         $transaction_master_old->delete(); 

                //     }

                //     $transaction_master = TransactionMaster::create([
                //         'receipt_payment_id' => $receipt_payment->id,
                //         // 'voucher_no' => 'BRV-' . (int) $request->tran_no . '/' . date('y'),
                //         'date' => date('Y-m-d'),
                //         'transaction_type_master_id' => 4,
                //         'account_id' => $request->account_id, // Credit
                //         'cost_center_id' => 1,
                //         'party_id' => $party_id->id,
                //         'currency_id' => 1,
                //         'exchange_rate' => $receipt_payment->exchange_rate,
                //         // 'cheque_date' => $request->cheque_date,
                //         'total_debit' => $request->net_received,
                //         'total_credit' => $request->net_received,
                //         'total_debit_converted' => $request->total_amount_conv,
                //         'total_credit_converted' => $request->total_amount_conv,
                //         // 'bank_sub_type' => $request->bank_sub_type,
                //         'company_id' => 1,
                //         'status' => 1,
                //         'narration' => $request->remarks,
                //         'created_by' => auth()->user()->id,
                //         'voucher_type_id' => 2
                //     ]);

                //     // Debit
                //     TransactionDetail::create([
                //         'transaction_master_id' => $transaction_master->id,
                //         'account_id' => $request->account_id,
                //         // 'cost_center_id' => $request->cost_center_detail[$key],
                //         'debit_vc' => $request->net_received,
                //         'credit_vc' => 0,
                //         'debit_lc' => $request->total_amount_conv,
                //         'credit_lc' => 0,
                //         'narration' => $request->remarks,
                //         'status' => 1
                //     ]);

                //     // Credit
                //     TransactionDetail::create([
                //         'transaction_master_id' => $transaction_master->id,
                //         'account_id' => $party_id->id,
                //         // 'cost_center_id' => $request->cost_center_detail[$key],
                //         'debit_vc' => 0,
                //         'credit_vc' => $request->net_received,
                //         'debit_lc' => 0,
                //         'credit_lc' => $request->total_amount_conv,
                //         'narration' => $request->remarks,
                //         'status' => 1
                //     ]);
                // } else {
                //     $transaction_master_old = TransactionMaster::where('receipt_payment_id', $receipt_payment->id)->first();
                //     if ($transaction_master_old) {
                //         // Delete related transaction details
                //         TransactionDetail::where('transaction_master_id', $transaction_master_old->id)->delete();
                //         // Delete the master record
                //         $transaction_master_old->delete(); 

                //     }
                //     $transaction_master = TransactionMaster::create([
                //         'receipt_payment_id' => $receipt_payment->id,
                //         // 'voucher_no' => 'BPV-' . (int) $request->tran_no . '/' . date('y'),
                //         'date' => date('Y-m-d'),
                //         'transaction_type_master_id' => 4,
                //         'account_id' => $request->account_id, // Credit
                //         'cost_center_id' => 1,
                //         'party_id' => $party_id->id,
                //         'currency_id' => 1,
                //         'exchange_rate' => $receipt_payment->exchange_rate,
                //         // 'cheque_date' => $request->cheque_date,
                //         'total_debit' => $request->net_received,
                //         'total_credit' => $request->net_received,
                //         'total_debit_converted' => $request->total_amount_conv,
                //         'total_credit_converted' => $request->total_amount_conv,
                //         // 'bank_sub_type' => $request->bank_sub_type,
                //         'company_id' => 1,
                //         'status' => 1,
                //         'narration' => $request->remarks,
                //         'created_by' => auth()->user()->id,
                //         'voucher_type_id' => 1
                //     ]);

                //     // Debit
                //     // TransactionDetail::where('transaction_master_id', $transaction_master->id)->delete();
                //     TransactionDetail::create([
                //         'transaction_master_id' => $transaction_master->id,
                //         'account_id' => $party_id->id,
                //         // 'cost_center_id' => $request->cost_center_detail[$key],
                //         'debit_vc' => $request->net_received,
                //         'credit_vc' => 0,
                //         'debit_lc' => $request->total_amount_conv,
                //         'credit_lc' => 0,
                //         'narration' => $request->remarks,
                //         'status' => 1
                //     ]);

                //     // Credit
                //     TransactionDetail::create([
                //         'transaction_master_id' => $transaction_master->id,
                //         'account_id' => $request->account_id,
                //         // 'cost_center_id' => $request->cost_center_detail[$key],
                //         'debit_vc' => 0,
                //         'credit_vc' => $request->net_received,
                //         'debit_lc' => 0,
                //         'credit_lc' => $receipt_payment->total_amount_conv,
                //         'narration' => $request->remarks,
                //         'status' => 1
                //     ]);
                // }

                $remarks = $request->remarks;
                $type = $request->type;
                $nature = $request->nature;

                $currencyMap = [
                    1 => "PKR",
                    2 => "USD",
                    3 => "AED",
                    4 => "GPB",
                    5 => "EUR",
                    6 => "BDT",
                    7 => "OMR",
                ];

                $currency = $currencyMap[$request->currency] ?? "PKR";

                if ($remarks === null) {
                    $partyName = $receipt_payment->party->name ?? '';
                    $fromOrTo = $type === 'receipt' ? 'From' : 'To';
                    $receivedOrPaid = $type === 'receipt' ? 'Received' : 'Paid';

                    $via = $type === 'receipt' ? [
                        'Cash' => 'Received Cash',
                        'Cheque' => 'Received Cheque',
                        'Pay Order' => 'Received Pay Order',
                        'TT' => 'Received TT',
                        'Credit Card' => 'Credit Card Payment',
                        'Online Transfer' => 'Online Transferred',
                    ] : [
                        'Cash' => 'Paid Cash',
                        'Cheque' => 'Paid via Cheque',
                        'Pay Order' => 'Paid via Pay Order',
                        'TT' => 'Paid via TT',
                        'Credit Card' => 'Credit Card Payment',
                        'Online Transfer' => 'Online Transfer',
                    ];

                    $remarksTypeText = $via[$nature] ?? ($receivedOrPaid . " Amount");

                    $commonDetails = function ($key) use ($request) {
                        return ($request->invoice_tran_no[$key] ?? '-') . " / " .
                            ($request->hbl_no[$key] ?? '-') . " / " .
                            ($request->mbl_no[$key] ?? '-') . " / " .
                            ($request->job_no[$key] ?? '-') . " / " .
                            ($request->file_no[$key] ?? '-') . " / " .
                            ($request->ref_tran_no[$key] ?? '-') .
                            " ( PKR " . ($request->rcvd_converted_amount[$key] ?? '0') . " )";
                    };

                    if (!empty($request->invoice_id) && is_array($request->invoice_id)) {
                        foreach ($request->invoice_id as $key => $value) {
                            if (!empty($request->rcvd_amount[$key]) && $request->rcvd_amount[$key] != 0 && $request->rcvd_amount[$key] != '-') {
                                if ($nature === 'Cheque') {
                                    $remarks .= "$remarksTypeText # " . ($request->cheque_number ?? '-') . " Dated " . ($request->cheque_date ?? '-') . " Against Inv/HBL/MBL/Job No(s)/File No/Reference No/Vehicle No: ";
                                } else {
                                    $remarks .= "$remarksTypeText Against Inv/HBL/MBL/Job No(s)/File No/Reference No/Vehicle No: ";
                                }
                                $remarks .= $commonDetails($key) . ", ";
                            }
                        }
                        $remarks = rtrim($remarks, ', ') . " $fromOrTo " . $partyName;
                    } else {
                        if ($nature === 'Cheque') {
                            $remarks = "$remarksTypeText # " . ($request->cheque_number ?? '-') . " Dated " . ($request->cheque_date ?? '-') . " Against Advance ( $currency " . ($request->advance ?? '0') . " ) $fromOrTo " . $partyName;
                        } else {
                            $remarks = "$remarksTypeText Against Advance ( $currency " . ($request->advance ?? '0') . " ) $fromOrTo " . $partyName;
                        }
                    }

                    // Save the final remarks
                    $receipt_payment->remarks = $remarks;
                    $transaction_master->narration = $remarks;
                    TransactionDetail::where('transaction_master_id', $transaction_master->id)->update([
                        'narration' => $remarks
                    ]);
                    $receipt_payment->save();
                }
                $logController->createLog(__METHOD__, 'success', 'SE Receipt Updated.', auth()->user(), '');

                $url = $request->getRequestUri();

                // if ($url == "/receipt/edit/" . $receipt_payment->id) {
                //     return redirect()->to('/receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                // } else {
                //     return redirect()->to('/se_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                // }
                if ($url == "/receipt/edit/" . $receipt_payment->id) {
                    return redirect()->to('/receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                } else if ($url == "/se_receipt/edit/" . $receipt_payment->id) {
                    return redirect()->to('/se_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                } else if ($url == "/si_receipt/edit/" . $receipt_payment->id) {
                    return redirect()->to('/si_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                } else if ($url == "/ae_receipt/edit/" . $receipt_payment->id) {
                    return redirect()->to('/ae_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                } else if ($url == "/ai_receipt/edit/" . $receipt_payment->id) {
                    return redirect()->to('/ai_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
                }
            }
            // return redirect()->to('/se_receipt/edit/' . $receipt_payment->id)->with('success', 'Record Updated SuccessFully!');
        } catch (Exception $e) {
            dd($e);

            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }
    public function updateStatus(TransactionMaster $transaction_master, $status)
    {
        TransactionMaster::where('id', $transaction_master->id)->update([
            'status' => $status
        ]);

        return redirect()->back();
    }

    public function print(ReceiptPayments $receipt_payment, LogsController $logController, Request $request)
    {
        try {
            $print_option = $request->print_option;
            $hbl_mbl_option = $request->hbl_mbl_option;
            $print_logo = $request->print_logo;
            $print_on_letterhead = $request->print_on_letterhead;
            // dd($print_on_letterhead);
            $show_account_no = $request->show_account_no;
            $logController->createLog(__METHOD__, 'success', 'Receipt Print.', auth()->user(), '');
            $receipt_payment_detail = ReceiptPaymentsDetail::where('receipt_payment_id', $receipt_payment->id)->get();
            $transaction_master = TransactionMaster::where('receipt_payment_id', $receipt_payment->id)->first();
            return view('sea_export.se_receipt.pdf', compact('receipt_payment', 'receipt_payment_detail', 'transaction_master', 'print_option', 'hbl_mbl_option', 'print_logo', 'print_on_letterhead', 'show_account_no'));
        } catch (Exception $e) {
            $logController->createLog(__METHOD__, 'error', $e, auth()->user(), '');

            return redirect()->back()->with('error', 'Something Went Wrong!');
        }
    }

    public function destroy($id, LogsController $logController)
    {
        DB::beginTransaction();

        try {
            // Load the RP plus details (fallback query if relation not defined)
            $receiptPayment = ReceiptPayments::findOrFail($id);

            // Prefer relation if you have it: $receiptPayment->details
            $details = ReceiptPaymentsDetail::where('receipt_payment_id', $receiptPayment->id)->get();

            // 1) Delete accounting entries (TransactionMaster + TransactionDetail)
            $masters = TransactionMaster::where('receipt_payment_id', $receiptPayment->id)->get();
            foreach ($masters as $master) {
                TransactionDetail::where('transaction_master_id', $master->id)->delete();
                $master->delete();
            }

            // 2) Re-evaluate affected invoices/bills AFTER removing this RP
            foreach ($details as $d) {
                if ($receiptPayment->type === 'receipt') {
                    // Customer invoices (Transactions)
                    $invoice = Transactions::find($d->invoice_id);
                    if ($invoice) {
                        // Sum of all other receipt allocations against this invoice (exclude the one being deleted)
                        $applied = ReceiptPaymentsDetail::where('invoice_id', $d->invoice_id)
                            ->whereHas('receipt_payment', function ($q) use ($id) {
                                $q->where('type', 'receipt')->where('id', '<>', $id);
                            })
                            ->sum('rcvd_amount');

                        // If you store the invoice total under a different field, adjust here:
                        $grandTotal = (float) ($invoice->grand_local_amount ?? $invoice->grand_net_amount ?? 0);
                        $net = $grandTotal - (float) $applied;

                        // Assuming: 1 = open/partial, 2 = settled/closed
                        $invoice->status = ($net == 0.0) ? 2 : 1;
                        $invoice->save();
                    }
                } else {
                    // Vendor bills (Bills)
                    $bill = Bills::find($d->invoice_id);
                    if ($bill) {
                        $applied = ReceiptPaymentsDetail::where('invoice_id', $d->invoice_id)
                            ->whereHas('receipt_payment', function ($q) use ($id) {
                                $q->where('type', 'payment')->where('id', '<>', $id);
                            })
                            ->sum('rcvd_amount');

                        $grandTotal = (float) ($bill->grand_local_amount ?? $bill->grand_net_amount ?? 0);
                        $net = $grandTotal - (float) $applied;

                        // Assuming: 1 = open/partial, 2 = settled/closed
                        $bill->status = ($net == 0.0) ? 2 : 1;
                        $bill->save();
                    }
                }
            }

            // 3) Delete this RP's detail rows
            ReceiptPaymentsDetail::where('receipt_payment_id', $receiptPayment->id)->delete();

            // 4) Delete the RP header
            $receiptPayment->delete();

            // 5) Log + commit
            $logController->createLog(__METHOD__, 'success', json_encode(['receipt_payment' => $receiptPayment]), auth()->user(), 'deleted');
            DB::commit();

            return redirect()->back()->with('success', 'Record deleted successfully.');
        } catch (\Throwable $e) {
            DB::rollBack();
            $logController->createLog(__METHOD__, 'error', $e->getMessage(), auth()->user(), '');
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

}
