<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Salesrepstatus;
use App\Http\Requests\SalesrepstatusRequest;

class SalesrepstatusesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $salesrepstatuses= Salesrepstatus::paginate(10);
        return view('salesrepstatuses.index', ['salesrepstatuses'=>$salesrepstatuses]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('salesrepstatuses.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  SalesrepstatusRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(SalesrepstatusRequest $request)
    {
        $salesrepstatus = new Salesrepstatus;
		$salesrepstatus->sales_rep = $request->input('sales_rep');
		$salesrepstatus->status = $request->input('status');
		$salesrepstatus->remarks = $request->input('remarks');
        $salesrepstatus->save();

        return to_route('salesrepstatuses.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $salesrepstatus = Salesrepstatus::findOrFail($id);
        return view('salesrepstatuses.show',['salesrepstatus'=>$salesrepstatus]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $salesrepstatus = Salesrepstatus::findOrFail($id);
        return view('salesrepstatuses.edit',['salesrepstatus'=>$salesrepstatus]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  SalesrepstatusRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(SalesrepstatusRequest $request, $id)
    {
        $salesrepstatus = Salesrepstatus::findOrFail($id);
		$salesrepstatus->sales_rep = $request->input('sales_rep');
		$salesrepstatus->status = $request->input('status');
		$salesrepstatus->remarks = $request->input('remarks');
        $salesrepstatus->save();

        return to_route('salesrepstatuses.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $salesrepstatus = Salesrepstatus::findOrFail($id);
        $salesrepstatus->delete();

        return to_route('salesrepstatuses.index');
    }
}
