<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Airport;
use App\Http\Requests\AirportRequest;
use App\Models\City;
use App\Models\Country;
use App\Models\Employee;
use App\Models\JobMaster;
use App\Models\Party;
use App\Models\Un_location;
use App\Models\Vessel;
use App\Models\Voyage;

class StuffingPlanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('sea_export.stuffing_plan.index');
    }

    public function add(JobMaster $job_master)
    {
        
        $un_locations = Un_location::where('status', 1)->get();
        $vessels = Vessel::where('status', 1)->get();
        $voyages = Voyage::where('status', 1)->get();
        $overseas_agent = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->whereIn('type_id', [7, 13]);
        })->get();
        $shipping_line = Party::whereHas('party_type', function ($subQuery) {
            $subQuery->where('type_id', 12);
        })->get();
        $sales_rep = Employee::where('status', 1)->get();
        return view('sea_export.stuffing_plan.add', compact('un_locations', 'job_master', 'vessels', 'voyages', 'overseas_agent', 'shipping_line', 'sales_rep'));
    }
}
