<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Team;
use App\Http\Requests\TeamRequest;

class TeamsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $teams= Team::paginate(10);
        return view('teams.index', ['teams'=>$teams]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('teams.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  TeamRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(TeamRequest $request)
    {
        $team = new Team;
		$team->code = $request->input('code');
		$team->name = $request->input('name');
		$team->status = $request->input('status');
        $team->save();

        return to_route('teams.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $team = Team::findOrFail($id);
        return view('teams.show',['team'=>$team]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $team = Team::findOrFail($id);
        return view('teams.edit',['team'=>$team]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  TeamRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(TeamRequest $request, $id)
    {
        $team = Team::findOrFail($id);
		$team->code = $request->input('code');
		$team->name = $request->input('name');
		$team->status = $request->input('status');
        $team->save();

        return to_route('teams.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $team = Team::findOrFail($id);
        $team->delete();

        return to_route('teams.index');
    }
}
