<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Un_location;
use App\Http\Requests\Un_locationRequest;
use Illuminate\Http\Request;

class Un_locationsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index(Request $request)
    {
        $perPage = $request->input('perPage', session('perPage', 100));

        // Save perPage value in session
        session(['un_location_perPage' => $perPage]);

        // Maintain other query parameters (like page number) using withQueryString
        $un_locations = \App\Models\Un_location::paginate($perPage)->withQueryString();

        return view('un_locations.index', compact('un_locations', 'perPage'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('un_locations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Un_locationRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Un_locationRequest $request)
    {
        // dd($request->all());
        $un_location = new Un_location;
		$un_location->name = $request->input('location');
		$un_location->country = $request->input('country');
		$un_location->city = $request->input('city');
		$un_location->airport = $request->input('airport');
		$un_location->seaport = $request->input('seaport');
		$un_location->terminal = $request->input('terminal');
		$un_location->coordinates = $request->input('coordinates');
		$un_location->latitude = $request->input('latitude');
		$un_location->state = $request->input('state');
		$un_location->longitude = $request->input('longitude');
		$un_location->phone_prefix = $request->input('phone_prefix');
		$un_location->epass_code = $request->input('epass_code');
		$un_location->category_region = $request->input('category_region');
		$un_location->status = $request->input('status');
        $un_location->save();

        return to_route('un_locations.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $un_location = Un_location::findOrFail($id);
        return view('un_locations.show',['un_location'=>$un_location]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $un_location = Un_location::findOrFail($id);
        return view('un_locations.edit',['un_location'=>$un_location]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Un_locationRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(Un_locationRequest $request, $id)
    {
        $un_location = Un_location::findOrFail($id);
		$un_location->name = $request->input('location');
		$un_location->country = $request->input('country');
		$un_location->city = $request->input('city');
		$un_location->airport = $request->input('airport');
		$un_location->seaport = $request->input('seaport');
		$un_location->terminal = $request->input('terminal');
		$un_location->coordinates = $request->input('coordinates');
		$un_location->latitude = $request->input('latitude');
		$un_location->state = $request->input('state');
		$un_location->longitude = $request->input('longitude');
		$un_location->phone_prefix = $request->input('phone_prefix');
		$un_location->epass_code = $request->input('epass_code');
		$un_location->category_region = $request->input('category_region');
		$un_location->status = $request->input('status');
        $un_location->save();

        return to_route('un_locations.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $un_location = Un_location::findOrFail($id);
        $un_location->delete();

        return to_route('un_locations.index');
    }
}
