<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\VendorGroup;
use App\Http\Requests\VendorGroupRequest;

class VendorGroupsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $vendorgroups= VendorGroup::paginate(10);
        return view('vendorgroups.index', ['vendorgroups'=>$vendorgroups]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('vendorgroups.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VendorGroupRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(VendorGroupRequest $request)
    {
        $vendorgroup = new VendorGroup;
		$vendorgroup->name = $request->input('name');
		$vendorgroup->status = $request->input('status');
        $vendorgroup->save();

        return to_route('vendorgroups.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $vendorgroup = VendorGroup::findOrFail($id);
        return view('vendorgroups.show',['vendorgroup'=>$vendorgroup]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $vendorgroup = VendorGroup::findOrFail($id);
        return view('vendorgroups.edit',['vendorgroup'=>$vendorgroup]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  VendorGroupRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(VendorGroupRequest $request, $id)
    {
        $vendorgroup = VendorGroup::findOrFail($id);
		$vendorgroup->name = $request->input('name');
		$vendorgroup->status = $request->input('status');
        $vendorgroup->save();

        return to_route('vendorgroups.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $vendorgroup = VendorGroup::findOrFail($id);
        $vendorgroup->delete();

        return to_route('vendorgroups.index');
    }
}
