<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\VesselMapping;
use App\Http\Requests\VesselMappingRequest;

class VesselMappingsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $vesselmappings= VesselMapping::paginate(10);
        return view('vesselmappings.index', ['vesselmappings'=>$vesselmappings]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('vesselmappings.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VesselMappingRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(VesselMappingRequest $request)
    {
        $vesselmapping = new VesselMapping;
		$vesselmapping->integration_code = $request->input('integration_code');
		$vesselmapping->integration_name = $request->input('integration_name');
		$vesselmapping->csul_code = $request->input('csul_code');
		$vesselmapping->csul_name = $request->input('csul_name');
		$vesselmapping->status = $request->input('status');
        $vesselmapping->save();

        return to_route('vesselmappings.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $vesselmapping = VesselMapping::findOrFail($id);
        return view('vesselmappings.show',['vesselmapping'=>$vesselmapping]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $vesselmapping = VesselMapping::findOrFail($id);
        return view('vesselmappings.edit',['vesselmapping'=>$vesselmapping]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  VesselMappingRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(VesselMappingRequest $request, $id)
    {
        $vesselmapping = VesselMapping::findOrFail($id);
		$vesselmapping->integration_code = $request->input('integration_code');
		$vesselmapping->integration_name = $request->input('integration_name');
		$vesselmapping->csul_code = $request->input('csul_code');
		$vesselmapping->csul_name = $request->input('csul_name');
		$vesselmapping->status = $request->input('status');
        $vesselmapping->save();

        return to_route('vesselmappings.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $vesselmapping = VesselMapping::findOrFail($id);
        $vesselmapping->delete();

        return to_route('vesselmappings.index');
    }
}
