<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Vessel;
use App\Http\Requests\VesselRequest;
use App\Models\Country;

class VesselsController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $vessels = Vessel::paginate(10);
        return view('vessels.index', ['vessels' => $vessels]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $countries = Country::where('status', 1)->get();
        return view('vessels.create', compact('countries'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VesselRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(VesselRequest $request)
    {
        $vessel = new Vessel;
        $vessel->name = $request->input('name');
        $vessel->owner = $request->input('owner');
        $vessel->principle_code = $request->input('principle_code');
        $vessel->call_sign = $request->input('call_sign');
        $vessel->grt = $request->input('grt');
        $vessel->nrt = $request->input('nrt');
        $vessel->imo_no = $request->input('imo_no');
        $vessel->country_id = $request->input('country_id');
        $vessel->status = $request->input('status');
        $vessel->save();

        return to_route('vessels.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $vessel = Vessel::findOrFail($id);
        return view('vessels.show', ['vessel' => $vessel]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $vessel = Vessel::findOrFail($id);
        $countries = Country::where('status', 1)->get();
        return view('vessels.edit', ['vessel' => $vessel, 'countries' => $countries]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  VesselRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(VesselRequest $request, $id)
    {
        $vessel = Vessel::findOrFail($id);
        $vessel->name = $request->input('name');
        $vessel->owner = $request->input('owner');
        $vessel->principle_code = $request->input('principle_code');
        $vessel->call_sign = $request->input('call_sign');
        $vessel->grt = $request->input('grt');
        $vessel->nrt = $request->input('nrt');
        $vessel->imo_no = $request->input('imo_no');
        $vessel->country_id = $request->input('country_id');
        $vessel->status = $request->input('status');
        $vessel->save();

        return to_route('vessels.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $vessel = Vessel::findOrFail($id);
        $vessel->delete();

        return to_route('vessels.index');
    }
}
