<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Voyage;
use App\Http\Requests\VoyageRequest;
use App\Models\Un_location;
use App\Models\Vessel;

class VoyagesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $voyages = Voyage::paginate(10);
        return view('voyages.index', ['voyages' => $voyages]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        $vessels = Vessel::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();

        return view('voyages.create', compact('vessels', 'un_locations'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  VoyageRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(VoyageRequest $request)
    {
        $voyage = new Voyage;
        $voyage->vessel_id = $request->input('vessel_id');
        $voyage->voyage_no = $request->input('voyage_no');
        $voyage->point_of_discharge_id = $request->input('point_of_discharge_id');
        $voyage->point_of_loading_id = $request->input('point_of_loading_id');
        $voyage->import_sail_date_time = $request->input('import_sail_date_time');
        $voyage->import_arrival_date = $request->input('import_arrival_date');
        $voyage->export_sailing_date = $request->input('export_sailing_date');
        $voyage->export_dest_eta = $request->input('export_dest_eta');
        $voyage->export_cut_of_date = $request->input('export_cut_of_date');
        $voyage->export_cut_of_time = $request->input('export_cut_of_time');
        $voyage->type = $request->input('type');
        $voyage->status = $request->input('status');
        $voyage->save();

        return to_route('voyages.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $voyage = Voyage::findOrFail($id);
        return view('voyages.show', ['voyage' => $voyage]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $voyage = Voyage::findOrFail($id);
        $vessels = Vessel::where('status', 1)->get();
        $un_locations = Un_location::where('status', 1)->get();

        return view('voyages.edit', ['voyage' => $voyage, 'vessels' => $vessels, 'un_locations' => $un_locations]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  VoyageRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(VoyageRequest $request, $id)
    {
        $voyage = Voyage::findOrFail($id);
        $voyage->vessel_id = $request->input('vessel_id');
        $voyage->voyage_no = $request->input('voyage_no');
        $voyage->point_of_discharge_id = $request->input('point_of_discharge_id');
        $voyage->point_of_loading_id = $request->input('point_of_loading_id');
        $voyage->import_sail_date_time = $request->input('import_sail_date_time');
        $voyage->import_arrival_date = $request->input('import_arrival_date');
        $voyage->export_sailing_date = $request->input('export_sailing_date');
        $voyage->export_dest_eta = $request->input('export_dest_eta');
        $voyage->export_cut_of_date = $request->input('export_cut_of_date');
        $voyage->export_cut_of_time = $request->input('export_cut_of_time');
        $voyage->type = $request->input('type');
        $voyage->status = $request->input('status');
        $voyage->save();

        return to_route('voyages.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $voyage = Voyage::findOrFail($id);
        $voyage->delete();

        return to_route('voyages.index');
    }
}
