<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;

use App\Models\Wharf;
use App\Http\Requests\WharfRequest;

class WharvesController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function index()
    {
        $wharves= Wharf::paginate(10);
        return view('wharves.index', ['wharves'=>$wharves]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function create()
    {
        return view('wharves.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  WharfRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(WharfRequest $request)
    {
        $wharf = new Wharf;
		$wharf->code = $request->input('code');
		$wharf->short_name = $request->input('short_name');
		$wharf->wharf = $request->input('wharf');
		$wharf->lp_header = $request->input('lp_header');
		$wharf->email = $request->input('email');
		$wharf->status = $request->input('status');
        $wharf->save();

        return to_route('wharves.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function show($id)
    {
        $wharf = Wharf::findOrFail($id);
        return view('wharves.show',['wharf'=>$wharf]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Contracts\View\View
     */
    public function edit($id)
    {
        $wharf = Wharf::findOrFail($id);
        return view('wharves.edit',['wharf'=>$wharf]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  WharfRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(WharfRequest $request, $id)
    {
        $wharf = Wharf::findOrFail($id);
		$wharf->code = $request->input('code');
		$wharf->short_name = $request->input('short_name');
		$wharf->wharf = $request->input('wharf');
		$wharf->lp_header = $request->input('lp_header');
		$wharf->email = $request->input('email');
		$wharf->status = $request->input('status');
        $wharf->save();

        return to_route('wharves.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function destroy($id)
    {
        $wharf = Wharf::findOrFail($id);
        $wharf->delete();

        return to_route('wharves.index');
    }
}
