<?php

namespace App\Imports;

use App\Models\City;
use App\Models\Party;
use App\Models\PartyDetailOperation;
use App\Models\PartyDetailType;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class PartiesImport implements ToCollection, WithHeadingRow
{
    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        DB::beginTransaction();
        try {
            foreach ($rows as $row) {

                $party = Party::create([
                    'name' => @$row['party_name'],
                    'reg_date' => Carbon::parse(@$row['registration_date']),
                    // 'contact_person' => ,
                    'address' => @$row['address_1'] . ', ' . @$row['address_2'],
                    'city_id' => @$row['city_id'],
                    'country_id' => @$row['country_id'],
                    // 'zip_code' => 1,
                    'phone_no' => @$row['telephone_1'],
                    'mobile' => @$row['telephone_2'],
                    'email' => @$row['email'],
                    'website' => @$row['website'],
                    // 'import_nomination' => 1,
                    // 'export_nomination' => 1,
                    // 'company_restriction' => 1,
                    // 'cost_center_restriction' => 1,
                    'ntn_no' => @$row['ein_vat'],
                    'strn_no' => @$row['ein_vat'],
                    // 'license_no' => 1,
                    'party_is' => 1,
                    'status' => 1,
                    'created_at' => now(),
                    'updated_at' => now(),
                    // 'deleted_at' => 1,
                    // 'manual_account' => 1
                ]);

                if($row['sea_export'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['sea_import'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 2,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['air_export'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 3,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['air_import'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 4,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['ware_house'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 6,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['depo'] == 'Yes'){
                    PartyDetailOperation::create([
                        'party_id' => $party->id,
                        'operation_id' => 7,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['shipper'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 1,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['consignee'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 2,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['notify'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 3,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['potential_customer'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 4,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['forwarder_coloader'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 5,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['local_vendor'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 6,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['overseas_agent'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 7,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['commission_agent'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 8,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['indentor'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 9,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['transporter'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 10,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['cha_chb'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 11,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['shipping_line'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 12,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['delivery_agent'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 13,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['warehouse_party'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 14,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['buying_house'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 15,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['air_line'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 17,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['trucking'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 18,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['drayman'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 19,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['cartage'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 20,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['stevedore'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 21,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['principal'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 22,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['depoparty'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 23,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['terminal_party'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 24,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['buyer'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 25,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['billing_party'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 26,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }

                if($row['slotoperator'] == 'Yes'){
                    PartyDetailType::create([
                        'party_id' => $party->id,
                        'type_id' => 27,
                        'created_at' => now(),
                        'updated_at' => now(),
                    ]);
                }
            }

            DB::commit();
        } catch (Exception $e) {
            DB::rollBack();
            dd($e);
        }
    }
}
