<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BillCharges extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'bill_charges';
    protected $guarded = [];
    public $timestamps = true;

    public function currency_name()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency');
    }

    public function charge()
    {
        return $this->belongsTo(Charge::class, 'charge_id');
    }
}
