<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bills extends Model
{
    use HasFactory;

    protected $table = 'bills';
    protected $guarded = [];
    public $timestamps = true;


    public function bill_charges()
    {
        return $this->hasMany(BillCharges::class, 'bill_id', 'id');
    }

    public function job_master()
    {
        return $this->belongsTo(JobMaster::class);
    }

    public function vendor()
    {
        return $this->belongsTo(Party::class, 'vendor_id', 'id');
    }
    public function receipt_payment_details()
    {
        return $this->hasMany(ReceiptPaymentsDetail::class, 'invoice_id', 'id');
    }
}
