<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlBookingInfo extends Model
{
    use HasFactory;

    protected $table = 'bl_booking_info';
    protected $guarded = [];
    public $timestamps = true;

    public function overseas_agent()
    {
        return $this->belongsTo(Party::class, 'overseas_agent_id');
    }

    public function port_of_loading()
    {
        return $this->belongsTo(Un_location::class, 'port_of_loading_id');
    }

    public function final_destination()
    {
        return $this->belongsTo(Un_location::class, 'final_destination_id');
    }

    public function port_of_discharge()
    {
        return $this->belongsTo(Un_location::class, 'port_of_discharge_id');
    }
    
    public function shipping_line()
    {
        return $this->belongsTo(Party::class, 'shipping_line_id');
    }
}
