<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BlMaster extends Model
{
    use HasFactory;

    protected $table = 'bl_master';
    protected $guarded = [];
    public $timestamps = true;

    public function bl_detail()
    {
        return $this->belongsTo(BlDetails::class, 'id', 'bl_master_id');
    }

    public function bl_booking_info()
    {
        return $this->belongsTo(BlBookingInfo::class, 'id', 'bl_master_id');
    }

    public function bl_ref_no()
    {
        return $this->belongsTo(BlRefNo::class, 'id', 'bl_master_id');
    }

    public function bl_container_info()
    {
        return $this->hasMany(BlContainerInfo::class);
    }
    public function vessel()
    {
        return $this->belongsTo(Vessel::class, 'vessel_id');
    }
    public function voyage()
    {
        return $this->belongsTo(Voyage::class, 'voyage_id');
    }
    public function notify_party()
    {
        return $this->belongsTo(Party::class, 'notify_party_one');
    }

    public function shipper()
    {
        return $this->belongsTo(Party::class, 'shipper_id');
    }
    public function consignee()
    {
        return $this->belongsTo(Party::class, 'consignee_id');
    }

    public function job_master()
    {
        return $this->belongsTo(JobMaster::class, 'job_master_id');
    }
    public function airline()
    {
        return $this->belongsTo(Party::class, 'airline_id');
    }

}
