<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ChartOfAccounts extends Model
{
	use SoftDeletes;

	protected $table = 'chart_of_accounts';
	protected $guarded = [];
	public $timestamps = true;

	public function account_category()
	{
		return $this->belongsTo(AccountCategory::class, 'category_id');
	}

	public function account_sub_category()
	{
		return $this->belongsTo(AccountSubCategory::class, 'sub_category_id');
	}

	public function parent_account()
	{
		return $this->belongsTo(ChartOfAccounts::class, 'parent_account_id');
	}

	public function opening()
	{
		return $this->hasOne(ChartOfAccountsOpening::class, 'chart_of_account_id');
	}

	public function transactionDetails()
	{
		return $this->hasMany(TransactionDetail::class, 'account_id');
	}

	public function openingBalances()
	{
		return $this->hasMany(ChartOfAccountsOpening::class, 'chart_of_account_id');
	}

	public function voucherDetails()
	{
		return $this->hasMany(TransactionDetail::class, 'account_id');
	}

	public function party()
    {
        return $this->belongsTo(Party::class, 'party_id');
    }

	public function calculateBalance($categoryCode)
	{
		$debit = $this->transactionDetails()->sum('debit_lc');
		$credit = $this->transactionDetails()->sum('credit_lc');

		return ($categoryCode == '1' || $categoryCode == '5') ? $debit - $credit : $credit - $debit;
	}
}
