<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChequeBookDetail extends Model
{
    protected $table = 'cheque_book_detail';
    protected $guarded = [];
    public $timestamps = true;

    public function utilised()
    {
        return $this->hasOne(TransactionMaster::class, 'cheque_id');
    }

    public function cheque_book_master()
    {
        return $this->belongsTo(ChequeBookMaster::class, 'cheque_book_master_id');
    }
}
