<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChequeBookMaster extends Model
{
    protected $table = 'cheque_book_master';
    protected $guarded = [];
    public $timestamps = true;

    public function detail()
    {
        return $this->hasMany(ChequeBookDetail::class, 'cheque_book_master_id');
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccounts::class, 'account_id');
    }
}
