<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CroMaster extends Model
{
    use HasFactory;

    protected $table = 'cro_master';
    protected $guarded = [];
    public $timestamps = true;
     
    public function cro_detail()
    {
        return $this->belongsTo(CroDetail::class, 'id', 'cro_master_id');
    }
     
    public function cro_gatepass()
    {
        return $this->belongsTo(CroGatePass::class, 'id', 'cro_master_id');
    }
     
    public function cro_vessel()
    {
        return $this->belongsTo(CroVessel::class, 'id', 'cro_master_id');
    }

    public function job_master()
    {
        return $this->belongsTo(JobMaster::class, 'job_master_id');
    }
}
