<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobChargesPayable extends Model
{
    use HasFactory;

    protected $table = 'job_charges_payable';
    protected $guarded = [];
    public $timestamps = true;

    public function charge()
    {
        return $this->belongsTo(Charge::class, 'charge_id', 'id');
    }

    public function vendor()
    {
        return $this->belongsTo(Party::class, 'vendor_id', 'id');
    }

    
    public function approved_by_name()
    {
        return $this->belongsTo(User::class, 'approved_by', 'id');
    }

    public function job_master()
    {
        return $this->belongsTo(JobMaster::class, 'job_master_id', 'id');
    }
    public function currency_name()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency');
    }
    public function transaction_charges()
    {
        return $this->hasOne(BillCharges::class, 'job_charge_payable_id')
                    ->latestOfMany();
    }
}
