<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobChargesReceivable extends Model
{
    use HasFactory;

    protected $table = 'job_charges_receivable';
    protected $guarded = [];
    public $timestamps = true;

    public function charge()
    {
        return $this->belongsTo(Charge::class, 'charge_id', 'id');
    }

    public function customer()
    {
        return $this->belongsTo(Party::class, 'customer_id', 'id');
    }

    public function approved_by_name()
    {
        return $this->belongsTo(User::class, 'approved_by', 'id');
    }
    public function job_master()
    {
        return $this->belongsTo(JobMaster::class, 'job_master_id', 'id');
    }

    public function transaction_charges()
    {
        return $this->hasOne(TransactionCharges::class, 'job_charge_recievable_id')
                    ->latestOfMany();
    }


    public function currency_name()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency');
    }
}
