<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobDetail extends Model
{
    use HasFactory;

    protected $table = 'job_detail';
    protected $guarded = [];
    public $timestamps = true;

    
    public function shipper()
    {
        return $this->belongsTo(Party::class, 'shipper_id');
    }
    public function consignee()
    {
        return $this->belongsTo(Party::class, 'consignee_id');
    }
    public function commodity()
    {
        return $this->belongsTo(Commodity::class, 'commodity_id');
    }
    public function overseas_agent()
    {
        return $this->belongsTo(Party::class, 'overseas_agent_id');
    }
    public function local_vendor()
    {
        return $this->belongsTo(Party::class, 'local_vendor_id');
    }
    public function client()
    {
        return $this->belongsTo(Party::class, 'client_id');
    }
    public function custom_clearance()
    {
        return $this->belongsTo(Party::class, 'custom_clearance_id');
    }
    public function shipping_line()
    {
        return $this->belongsTo(Party::class, 'shipping_line_id');
    }
    public function sales_rep()
    {
        return $this->belongsTo(Employee::class, 'sales_rep_id');
    }
    public function final_destination()
    {
        return $this->belongsTo(Un_location::class, 'final_destination_id');
    }
    public function port_of_loading()
    {
        return $this->belongsTo(Un_location::class, 'port_of_loading_id');
    }
    public function port_of_discharge()
    {
        return $this->belongsTo(Un_location::class, 'port_of_discharge_id');
    }
}
