<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobMaster extends Model
{
    use HasFactory;

    protected $table = 'job_master';
    protected $guarded = [];
    public $timestamps = true;

    public function job_status()
    {
        return $this->belongsTo(JobStatus::class);
    }

    public function job_detail()
    {
        return $this->belongsTo(JobDetail::class, 'id', 'job_master_id');
    }

    public function job_vessel()
    {
        return $this->belongsTo(JobVessel::class, 'id', 'job_master_id');
    }

    public function job_weight()
    {
        return $this->belongsTo(JobWeight::class, 'id', 'job_master_id');
    }

    public function job_equipments()
    {
        return $this->hasMany(JobEquipments::class);
    }

    public function job_charges_receivable()
    {
        return $this->hasMany(JobChargesReceivable::class)->orderBy('order_index');
    }

    public function job_charges_payable()
    {
        return $this->hasMany(JobChargesPayable::class)->orderBy('order_index');
    }

    public function job_charges()
    {
        return $this->hasMany(JobCharges::class);
    }

    public function job_routing()
    {
        return $this->belongsTo(JobRouting::class, 'id', 'job_master_id');
    }

    public function job_other_info()
    {
        return $this->belongsTo(JobOtherInfo::class, 'id', 'job_master_id');
    }
    public function operation()
    {
        return $this->belongsTo(Operations::class, 'operation_id');
    }

    public function currency_name()
    {
        return $this->belongsTo(CurrencyMaster::class, 'ex_rate');
    }

    public function si_job_other_info()
    {
        return $this->belongsTo(SIJobOtherInfo::class, 'id', 'job_master_id');
    }
    public function ai_job_other_info()
    {
        return $this->belongsTo(AIJobOtherInfo::class, 'id', 'job_master_id');
    }
    public function ae_job_other_info()
    {
        return $this->belongsTo(AEJobOtherInfo::class, 'id', 'job_master_id');
    }

    public function bl_master()
    {
        return $this->hasOne(BlMaster::class, 'job_master_id');
    }
    public function cro_master()
    {
        return $this->hasOne(CroMaster::class, 'job_master_id');
    }
}
