<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobRouting extends Model
{
    use HasFactory;

    protected $table = 'job_routing';
    protected $guarded = [];
    public $timestamps = true;

    public function place_of_receipt()
    {
        return $this->belongsTo(Un_location::class, 'place_of_receipt_id');
    }
    public function port_of_loading()
    {
        return $this->belongsTo(Un_location::class, 'port_of_loading_id');
    }
    public function port_of_discharge()
    {
        return $this->belongsTo(Un_location::class, 'port_of_discharge_id');
    }
    public function final_destination()
    {
        return $this->belongsTo(Un_location::class, 'final_destination_id');
    }

}
