<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobVessel extends Model
{
    use HasFactory;

    protected $table = 'job_vessel';
    protected $guarded = [];
    public $timestamps = true;

    public function vessel()
    {
        return $this->belongsTo(Vessel::class, 'vessel_id');
    }
    public function voyage()
    {
        return $this->belongsTo(Voyage::class, 'voyage_id');
    }
    public function airline()
    {
        return $this->belongsTo(Party::class, 'airline_id');
    }
}
