<?php

namespace App\Models;

use App\Permissions\HasPermissionsTrait;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Party extends Model
{
    use SoftDeletes;

    protected $table = 'party';
    protected $guarded = [];
    public $timestamps = true;

    public function party_operations()
    {
        return $this->hasMany(PartyDetailOperation::class);
    }

    public function party_type()
    {
        return $this->hasMany(PartyDetailType::class);
    }
   
    public function party_location()
    {
        return $this->hasMany(PartyLocations::class);
    }
   
    public function chart_of_account()
    {
        return $this->hasOne(ChartOfAccounts::class, 'party_id');
    }
}
