<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ReceiptPayments extends Model
{
    use SoftDeletes;

    protected $table = 'receipt_payemnts';
    protected $guarded = [];
    public $timestamps = true;

    public function party()
    {
        return $this->belongsTo(Party::class, 'client_id', 'id');
    }
    public function operation()
    {
        return $this->belongsTo(Operations::class, 'operation_id', 'id');
    }

    public function client()
    {
        return $this->belongsTo(Party::class, 'client_id');
    }

    public function account()
    {
        return $this->belongsTo(ChartOfAccounts::class, 'account_id');
    }

    public function receipt_detail()
    {
        return $this->hasMany(ReceiptPaymentsDetail::class, 'receipt_payment_id');
    }

    public function transaction()
    {
        return $this->hasOne(TransactionMaster::class, 'receipt_payment_id');
    }
}
