<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model
{
    use SoftDeletes;
    protected $table = 'roles';
    protected $guarded = [];
    public $timestamps = true;

    public function permissions()
    {
        return $this->hasMany(PermissionRoles::class, 'role_id');
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }
}
