<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TransactionCharges extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'transaction_charges';
    protected $guarded = [];
    public $timestamps = true;

    public function transaction()
    {
        return $this->belongsTo(Transactions::class, 'transaction_id');
    }
    public function job_master()
    {
        return $this->belongsTo(JobMaster::class, 'job_id');
    }
    public function voucher()
    {
        return $this->belongsTo(TransactionMaster::class, 'transaction_master_id');
    }
    public function job_rec()
    {
        return $this->belongsTo(JobChargesReceivable::class, 'job_charge_recievable_id');
    }
    public function job_pay()
    {
        return $this->belongsTo(JobChargesPayable::class, 'job_charge_payable_id');
    }
    public function charge()
    {
        return $this->belongsTo(Charge::class, 'charge_id');
    }
    public function currency_name()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency');
    }

}
