<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TransactionDetail extends Model
{
    use SoftDeletes;
    
    protected $table = 'transaction_detail';
    protected $guarded = [];
    public $timestamps = true;

    public function account()
    {
        return $this->belongsTo(ChartOfAccounts::class, 'account_id');
    }

    public function transaction()
    {
        return $this->belongsTo(TransactionMaster::class, 'transaction_master_id');
    }
    public function currency()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency_id');
    }
}
