<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TransactionMaster extends Model
{
    use SoftDeletes;

    protected $table = 'transaction_master';
    protected $guarded = [];
    public $timestamps = true;


    public function currency()
    {
        return $this->belongsTo(CurrencyMaster::class, 'currency_id');
    }

    public function type()
    {
        return $this->belongsTo(TransactionTypeMaster::class, 'voucher_type_id');
    }
    public function payment_type()
    {
        return $this->belongsTo(PaymentTypeMaster::class, 'transaction_type_master_id');
    }

    public function transaction()
    {
        return $this->belongsTo(Transactions::class, 'transaction_id');
    }

    public function bill()
    {
        return $this->belongsTo(Bills::class, 'bill_id');
    }
    public function detail()
    {
        return $this->hasMany(TransactionDetail::class, 'transaction_master_id');
    }

    public function cost_center()
    {
        return $this->belongsTo(CostCenter::class, 'cost_center_id');
    }

    public function status_master()
    {
        return $this->belongsTo(TransactionStatusMaster::class, 'status');
    }

    public function created_by_user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    public function edited_by_user()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
    public function chart_of_accounts()
    {
        return $this->belongsTo(ChartOfAccounts::class, 'party_id');
    }
    public function chart_of_account()
    {
        return $this->belongsTo(ChartOfAccounts::class, 'account_id');
    }
    public function party()
    {
        return $this->belongsTo(Party::class, 'party_id');
    }
    public function receipt_payment()
    {
        return $this->belongsTo(ReceiptPayments::class, 'receipt_payment_id');
    }
}
