<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transactions extends Model
{
    use HasFactory;

    protected $table = 'transactions';
    protected $guarded = [];
    public $timestamps = true;


    public function transaction_charges()
    {
        return $this->hasMany(TransactionCharges::class, 'transaction_id', 'id');
    }

    public function type()
    {
        return $this->belongsTo(TransactionType::class, 'transaction_type_id');
    }

    public function job_master()
    {
        return $this->belongsTo(JobMaster::class);
    }
    public function receipt_payment_details()
    {
        return $this->hasMany(ReceiptPaymentsDetail::class, 'invoice_id', 'id');
    }
    public function client()
    {
        return $this->belongsTo(Party::class, 'client_id');
    }
    public function overseas_agent()
    {
        return $this->belongsTo(Party::class, 'overseas_agent_id');
    }
}
