<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateChargesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('charges', function (Blueprint $table) {
            $table->id();
			$table->string('code');
			$table->integer('currency_id');
			$table->string('name');
			$table->string('short_name');
			$table->string('charges_type');
			$table->string('order');
			$table->string('type');
			$table->string('reporting_group');
			$table->string('tag');
			$table->string('printing_name');
			$table->string('calculation_type');
			$table->integer('tax_recievable');
			$table->integer('tax_payable');
			$table->integer('tax_on_principal');
			$table->string('c_category');
			$table->string('default_payable');
			$table->string('default_recievable');
			$table->string('sys_gen');
			$table->integer('sea_import');
			$table->integer('sea_export');
			$table->integer('air_import');
			$table->integer('air_export');
			$table->integer('logistic');
			$table->integer('warehouse');
			$table->integer('other');
			$table->integer('operation_type');
			$table->integer('carrier_id');
			$table->string('billing_type');
			$table->integer('customer_id');
			$table->integer('vendor_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('charges');
    }
}
