<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateCommoditiesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('commodities', function (Blueprint $table) {
            $table->id();
			$table->string('code');
			$table->string('name');
			$table->string('short_code');
			$table->integer('hs_code_id');
			$table->string('cargo_type');
			$table->integer('commodity_group_id');
			$table->integer('hazmat_product');
			$table->string('packing_group');
			$table->string('hazmat_class');
			$table->string('uno_code');
			$table->string('hazmat_code');
			$table->string('chemical_name');
			$table->string('sro_string');
			$table->string('insurance');
			$table->string('landing_ins');
			$table->string('cd');
			$table->string('stax');
			$table->string('add_cd');
			$table->string('itax');
			$table->string('s_itax');
			$table->string('fed');
			$table->string('fine');
			$table->string('eto');
			$table->string('rd');
			$table->string('shipping_item');
			$table->string('warehouse_item');
			$table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('commodities');
    }
}
