<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;

class CreateVoyagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('voyages', function (Blueprint $table) {
            $table->id();
			$table->integer('vessel_id');
			$table->integer('voyage_no');
			$table->integer('point_of_discharge_id');
			$table->integer('point_of_loading_id');
			$table->timestamp('import_sail_date_time');
			$table->string('import_arrival_date');
			$table->string('export_sailing_date');
			$table->string('export_dest_eta');
			$table->string('export_cut_of_date');
			$table->string('export_cut_of_time');
			$table->integer('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('voyages');
    }
}
