@extends('layout.master')

@section('title')
    Account Activity Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/account-ledger') }}" class="breadcrumb-item">Accounts Activity Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/account-activity') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Accounts Activity Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">
                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date"
                                        value="{{ \Carbon\Carbon::now()->month >= 7
                                            ? \Carbon\Carbon::create(\Carbon\Carbon::now()->year, 7, 1)->format('Y-m-d')
                                            : \Carbon\Carbon::create(\Carbon\Carbon::now()->year - 1, 7, 1)->format('Y-m-d') }}"
                                        name="date_from" id="date_from" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="date_to" id="date_to" class="form-control">
                                </div>
                                <div class="col-md-4">
                                    <label>Debit Account</label>
                                    <select data-placeholder="Select Account" id="debit_account_id" name="debit_account_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Credit Account</label>
                                    <select data-placeholder="Select Account" id="credit_account_id"
                                        name="credit_account_id" class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label>Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full mt-2">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="voucher_no">Voucher No</label>
                                    <input type="text" id="voucher_no" name="voucher_no" class="form-control w-full"
                                        placeholder="Enter Voucher No">
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="Cheque_no">Cheque No</label>
                                    <input type="text" id="Cheque_no" name="cheque_no" class="form-control w-full"
                                        placeholder="Enter Cheque No">
                                </div>
                            </div>
                            <div class="row">
                                <div>
                                    <h1 class="text-center bg-danger fw-bold"
                                        style="background-color: rgba(255, 128, 0, 1.0); font-size: 20px">Log Filter</h1>
                                </div>
                                <div class="col-md-6 mt-6">
                                    <select data-placeholder="Select User" id="user_id" name="user_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select User</option>
                                        @foreach ($users as $user)
                                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <input type="radio" id="filter_created_by" name="log_filter" value="created_by"
                                        class="form-check-input">
                                    <label for="filter_created_by" class="form-check-label">Created By</label>
                                </div>
                                <div class="col-md-3 mt-10 mb-10">
                                    <input type="radio" id="filter_edited_by" name="log_filter" value="edited_by"
                                        class="form-check-input">
                                    <label for="filter_edited_by" class="form-check-label">Edited By</label>
                                </div>
                                <div>
                                    <hr>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <fieldset class="mb-3">
                                        <legend>Voucher Type</legend>
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_all" value="all" checked>
                                                    <label class="form-check-label" for="voucher_all">All</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_bvp" value="bvp">
                                                    <label class="form-check-label" for="voucher_bvp">BVP</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_brv" value="brv">
                                                    <label class="form-check-label" for="voucher_brv">BRV</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_cn" value="cn">
                                                    <label class="form-check-label" for="voucher_cn">CN</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_cpv" value="cpv">
                                                    <label class="form-check-label" for="voucher_cpv">CPV</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_crv" value="crv">
                                                    <label class="form-check-label" for="voucher_crv">CRV</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_jv" value="jv">
                                                    <label class="form-check-label" for="voucher_jv">JV</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_pi" value="pi">
                                                    <label class="form-check-label" for="voucher_pi">PI</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_si" value="si">
                                                    <label class="form-check-label" for="voucher_si">SI</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_tv" value="tv">
                                                    <label class="form-check-label" for="voucher_tv">TV</label>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" name="voucher_type[]"
                                                        id="voucher_dn" value="dn">
                                                    <label class="form-check-label" for="voucher_dn">DN</label>
                                                </div>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>
                            <hr>
                            <div class="row mt-5">
                                <div class="col-md-3 mt-10">
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="checkbox" name="show_add_edit_log"
                                            id="show_add_edit_log" value="1" checked>
                                        <label class="form-check-label" for="source_doc_no">Show Add/edit Log
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-3 mt-10">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="add_cost_center"
                                            id="add_cost_center" value="1" checked>
                                        <label class="form-check-label" for="hide_cheque_date">Add Cost Center In
                                            Narration
                                        </label>
                                    </div>
                                </div>
                                <div class="col-md-6" style="border: 1px solid #000; border-radius: 30px;">
                                    <div class="row">
                                        <div class="col-md-3 mt-10">
                                            <input type="radio" id="all" name="transaction_status"
                                                value="all" class="form-check-input" checked>
                                            <label for="all" class="form-check-label">All</label>
                                        </div>
                                        <div class="col-md-3 mt-10 mb-10">
                                            <input type="radio" id="posted" name="transaction_status"
                                                value="posted" class="form-check-input">
                                            <label for="posted" class="form-check-label">Posted</label>
                                        </div>
                                        <div class="col-md-3 mt-10 mb-10">
                                            <input type="radio" id="unposted" name="transaction_status"
                                                value="unposted" class="form-check-input">
                                            <label for="unposted" class="form-check-label">Unposted</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
