@extends('layout.master')

@section('title')
    Account-Activity-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Account Activity Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>
        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/account-activity') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                {{-- @if (is_array(request('parent_account_id'))) --}}
                    {{-- @foreach (request('parent_account_id') as $parent_id) --}}
                        <input type="hidden" name="debit_account_id" value="{{ request('debit_account_id') }}">
                    {{-- @endforeach --}}
                {{-- @endif --}}

                {{-- @if (is_array(request('child_account'))) --}}
                    {{-- @foreach (request('child_account') as $child_id) --}}
                        <input type="hidden" name="credit_account_id" value="{{ request('credit_account_id') }}">
                    {{-- @endforeach --}}
                {{-- @endif --}}

                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/account-activity') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                {{-- @if (is_array(request('parent_account_id'))) --}}
                    {{-- @foreach (request('parent_account_id') as $parent_id) --}}
                        <input type="hidden" name="debit_account_id" value="{{ request('debit_account_id') }}">
                    {{-- @endforeach --}}
                {{-- @endif --}}

                {{-- @if (is_array(request('child_account'))) --}}
                    {{-- @foreach (request('child_account') as $child_id) --}}
                        <input type="hidden" name="credit_account_id" value="{{ request('credit_account_id') }}">
                    {{-- @endforeach --}}
                {{-- @endif --}}

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap">
                    <thead>
                        <tr>
                            <th>S#</th>
                            <th>Particular</th>
                            <th>DebitLC</th>
                            <th>CreditLC</th>
                            <th>DebitVC</th>
                            <th>CreditVC</th>
                            @if ($add_cost_center == 1)
                                <th>CostCenter / Narration</th>
                            @else
                                <th>Narration</th>
                            @endif

                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($voucherDetails as $index => $voucher)
                            @php
                                $totalDebitLC = 0;
                                $totalCrebitLC = 0;
                                $totalDebitVC = 0;
                                $totalCrebitVC = 0;
                            @endphp
                            <tr>
                                <td style="background: #DCDCDC;" colspan="2">Voucher #: {{ $voucher->voucher_no }}</td>
                                <td style="background: #DCDCDC;" colspan="2">Voucher Date: {{ $voucher->date }}</td>
                                <td style="background: #DCDCDC;" colspan="2">Currency: {{ $voucher->currency->name }}
                                </td>
                                <td style="background: #DCDCDC;">ExchangeRate: {{ $voucher->exchange_rate }}</td>
                            </tr>
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $voucher->account?->account_code . ' - ' . $voucher->account?->name }}</td>
                                <td>{{ $voucher->debit_lc }}</td>
                                <td>{{ $voucher->crebit_lc }}</td>
                                <td>{{ $voucher->debit_vc }}</td>
                                <td>{{ $voucher->crebit_vc }}</td>
                                @if ($add_cost_center == 1)
                                    <td>{{ 'HEAD OFFICE' . ' / ' . $voucher->narration }}</td>
                                @else
                                    <td>{{ $voucher->narration }}</td>
                                @endif
                            </tr>
                            @php
                                $totalDebitLC += $voucher->debit_lc ?? 0;
                                $totalCrebitLC += $voucher->crebit_lc ?? 0;
                                $totalDebitVC += $voucher->debit_vc ?? 0;
                                $totalCrebitVC += $voucher->crebit_vc ?? 0;
                            @endphp
                            <tr>
                                <td style="background: #DCDCDC;" colspan="2">Total</td>
                                <td style="background: #DCDCDC;">{{ $totalDebitLC }}</td>
                                <td style="background: #DCDCDC;">{{ $totalCrebitLC }}</td>
                                <td style="background: #DCDCDC;">{{ $totalDebitVC }}</td>
                                <td style="background: #DCDCDC;">{{ $totalCrebitVC }}</td>
                                <td style="background: #DCDCDC;"></td>
                            </tr>
                            <tr>
                                <td colspan="2">Cheque # : {{ $voucher->voucher_no }}</td>
                                <td colspan="2">Cheque Date : {{ $voucher->date }}</td>
                                <td colspan="3">Source : {{ @$voucher->transaction->payment_type->name }}</td>
                            </tr>
                            <tr>
                                <td colspan="2">Created By : {{ @$voucher->transaction->created_by_user->name }}</td>
                                <td colspan="2">Created Date : {{ $voucher->created_at }}</td>
                                <td colspan="2">Edit By : {{ @$voucher->transaction->edited_by_user->name }}</td>
                                <td>Edit Date : {{ $voucher->updated_at }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Accounts Activity Report - YARAN</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Accounts Activity Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
