@extends('layout.master')

@section('title')
    Account-Activity-CostCenter-Wise-Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/account-activity-costcenter-wise') }}" class="breadcrumb-item">Accounts Activity
        CostCenter Wise Report</a><i data-feather="chevron-right" class="breadcrumb__icon"></i><a href=""
        class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/account-activity-costcenter-wise') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Accounts Activity CostCenter Wise Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Parent Account</label>
                                    <select data-placeholder="Select Account" id="account_id" name="account_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2 ">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                                value="Head Office">Head Office</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6" style="border: 1px solid #000;">
                                    <fieldset class="mb-3">
                                        <div class="d-flex flex-wrap mt-10">
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="checkbox" name="assets"
                                                    id="assets" value="1" {{ old('assets') ? 'checked' : '' }}>
                                                <label class="form-check-label" for="assets">Assets</label>
                                            </div>
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="checkbox" name="capital_expense"
                                                    id="capital_expense" value="1"
                                                    {{ old('capital_expense') ? 'checked' : '' }}>
                                                <label class="form-check-label" for="capital_expense">Capital</label>
                                            </div>
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="checkbox" name="expense"
                                                    id="expense" value="1" {{ old('expense') ? 'checked' : '' }} checked>
                                                <label class="form-check-label" for="expense">Expense</label>
                                            </div>
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="checkbox" name="liabilities"
                                                    id="liabilities" value="1"
                                                    {{ old('liabilities') ? 'checked' : '' }}>
                                                <label class="form-check-label" for="liabilities">Liabilities</label>
                                            </div>
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="checkbox" name="revenue"
                                                    id="revenue" value="1" {{ old('revenue') ? 'checked' : '' }} checked>
                                                <label class="form-check-label" for="revenue">Revenue</label>
                                            </div>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-1"></div>
                                <div class="col-md-5" style="border: 1px solid #000;">
                                    <div class="row mt-10 mb-3">
                                        <div class="col-md-3">
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="radio" name="report_type"
                                                    id="pl_checkbox" value="1" onchange="toggleCheckboxes()"
                                                    checked>
                                                <label class="form-check-label" for="pl_checkbox">P&L</label>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-check me-3">
                                                <input class="form-check-input" type="radio" name="report_type"
                                                    id="Balancing/movement" value="2" onchange="toggleCheckboxes()">
                                                <label class="form-check-label"
                                                    for="Balancing/movement">Balancing/movement</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        document.addEventListener('DOMContentLoaded', toggleCheckboxes);

        function toggleCheckboxes() {
            const reportType = document.querySelector('input[name="report_type"]:checked').value;
            const checkboxes = ['assets', 'capital_expense', 'liabilities'];
            checkboxes.forEach(id => {
                const checkbox = document.getElementById(id);
                if (reportType === '1') {
                    checkbox.checked = false;
                    checkbox.disabled = true;
                } else {
                    checkbox.disabled = false;
                }
            });
        }
    </script>
@endsection
