@extends('layout.master')

@section('title')
    Account-Activity-Cost-center-wise-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Account Activity Cost Center Wise Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>


        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            @php
                use Carbon\Carbon;

                // Get current month and the previous 5 months
                $currentMonth = Carbon::now();
                $months = collect();
                for ($i = 5; $i >= 0; $i--) {
                    $months->push($currentMonth->copy()->subMonths($i));
                }

                // Calculate total rows for rowspan (total number of rows in all categories and accounts)
                $totalRowCount =
                    $voucherDetails->sum(function ($parentAccounts) {
                        // Count the rows for categories and parent accounts, and add the rows for child accounts
                        return $parentAccounts->sum(function ($accounts) {
                            return $accounts->count(); // Count child accounts for each parent account
                        }) + $parentAccounts->count(); // Add parent account rows
                    }) + $voucherDetails->count();

                // Initialize grand total array for all months
                $grandTotal = array_fill(0, $months->count(), 0);
            @endphp

            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap">
                    <thead>
                        <tr>
                            <th rowspan="2">Company</th>
                            <th rowspan="2">Category</th>
                            <th rowspan="2">Parent Account</th>
                            <th rowspan="2">Account Name</th>
                            <th colspan="{{ $months->count() }}" class="text-center">{{ now()->year }}</th>
                        </tr>
                        <tr>
                            @foreach ($months as $month)
                                <th>{{ $month->format('F') }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <!-- Add the Company column with rowspan -->
                            <td rowspan="{{ $totalRowCount }}" style="background-color: LightGrey;">YARAN
                                SHIPPING LINE</td>

                            @foreach ($voucherDetails as $categoryName => $parentAccounts)
                                @php
                                    // Calculate the number of rows for the category (parent accounts + child accounts)
                                    $categoryRowCount =
                                        $parentAccounts->sum(fn($accounts) => $accounts->count()) +
                                        $parentAccounts->count();
                                @endphp

                                <!-- Category Row with rowspan -->
                                <td rowspan="{{ $categoryRowCount }}" style="background-color: LightGrey;">
                                    {{ $categoryName }}
                                </td>

                                @foreach ($parentAccounts as $parentAccountName => $accounts)
                                    @php
                                        // Count the number of rows for the parent account
                                        $parentRowCount = $accounts->count();
                                        $parentTotal = array_fill(0, $months->count(), 0); // Initialize parent total array
                                    @endphp

                                    <!-- Parent Account Row with rowspan -->
                                    <td rowspan="{{ $parentRowCount }}" style="background-color: LightGrey;">
                                        {{ $parentAccountName ?? 'No Parent Account' }}</td>

                                    @foreach ($accounts as $index => $account)
                                        <td>{{ $account->account_name }}</td>

                                        {{-- Columns for each month --}}
                                        @foreach ($months as $monthIndex => $month)
                                            @php
                                                $amount = 0;
                                                // Check if the account's date matches the current month
                                                    if (
                                                        Carbon::parse($account->date)->format('Y-m') ==
                                                        $month->format('Y-m')
                                                    ) {
                                                        if (in_array($categoryName, ['Assets', 'Expense'])) {
                                                            // For Assets and Expense, debit is added, credit is subtracted
                                                            $amount =
                                                                ($account->debit_lc ?? 0) - ($account->credit_lc ?? 0);
                                                        } elseif (
                                                            in_array($categoryName, ['Liability', 'Income', 'Capital'])
                                                    ) {
                                                        // For Liability, Revenue/Income, and Capital, credit is added, debit is subtracted
                                                        $amount =
                                                            ($account->credit_lc ?? 0) - ($account->debit_lc ?? 0);
                                                    }
                                                }

                                                // Update parent and grand totals
                                                $parentTotal[$monthIndex] += $amount;
                                                $grandTotal[$monthIndex] += $amount;
                                            @endphp
                                            <td>{{ $amount }}</td>
                                        @endforeach
                        </tr>
                        @endforeach

                        <!-- Parent Account Total Row -->
                        <tr style="background-color: LightGrey;">
                            <td colspan="2" style="text-align: right;"><strong>Total for
                                    {{ $parentAccountName }}</strong>
                            </td>
                            @foreach ($parentTotal as $total)
                                <td><strong>{{ $total }}</strong></td>
                            @endforeach
                        </tr>
                        @endforeach

                        <!-- Category Total Row -->
                        <tr style="background-color: LightGrey;">
                            <td colspan="3" style="text-align: right;"><strong>Total for
                                    {{ $categoryName }}</strong></td>
                            @foreach ($months as $monthIndex => $month)
                                @php
                                    // Initialize category total for the current month
                                    $categoryTotal = 0;

                                    // Loop through parent accounts and their child accounts
                                    foreach ($parentAccounts as $accounts) {
                                        foreach ($accounts as $account) {
                                            // Check if the account's date matches the current month
        if (Carbon::parse($account->date)->format('Y-m') == $month->format('Y-m')) {
            if (in_array($categoryName, ['Assets', 'Expense'])) {
                // For Assets and Expense, debit is added, credit is subtracted
                $categoryTotal +=
                    ($account->debit_lc ?? 0) - ($account->credit_lc ?? 0);
            } elseif (in_array($categoryName, ['Liability', 'Income', 'Capital'])) {
                                                    // For Liability, Revenue/Income, and Capital, credit is added, debit is subtracted
                                                    $categoryTotal +=
                                                        ($account->credit_lc ?? 0) - ($account->debit_lc ?? 0);
                                                }
                                            }
                                        }
                                    }
                                @endphp
                                <td><strong>{{ $categoryTotal }}</strong></td>
                            @endforeach
                        </tr>
                        @endforeach

                        <!-- Grand Total Row for all categories -->
                        <tr style="background-color: LightGrey;">
                            <td colspan="4" style="text-align: right;"><strong>Grand Total</strong></td>
                            @foreach ($grandTotal as $total)
                                <td><strong>{{ $total }}</strong></td>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Account Activity Cost Center Wise Report</title>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Account Activity Cost Center Wise Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Restore original page after printing
        });
    </script>
@endsection
