@extends('layout.master')

@section('title')
    Account Ledger Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('accounts/accounts/account-ledger') }}" class="breadcrumb-item">Accounts Ledger Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/account-ledger') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Accounts Ledger Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    {{-- <input type="date"
                                        value="{{ \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d') }}"
                                        name="date_from" id="date_from" class="form-control"> --}}
                                    <input type="date"
                                        value="{{ \Carbon\Carbon::now()->month >= 7
                                            ? \Carbon\Carbon::create(\Carbon\Carbon::now()->year, 7, 1)->format('Y-m-d')
                                            : \Carbon\Carbon::create(\Carbon\Carbon::now()->year - 1, 7, 1)->format('Y-m-d') }}"
                                        name="date_from" id="date_from" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ \Carbon\Carbon::now()->format('Y-m-d') }}"
                                        name="date_to" id="date_to" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Parent Account</label>
                                    <select data-placeholder="Select Account" id="parent_account_id"
                                        name="parent_account_id[]" class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Account</label>
                                    <select multiple data-placeholder="Select Account" id="child_account"
                                        name="child_account[]" class="tom-select w-full">
                                        <option value="">Please Select Account</option>
                                        @foreach ($child_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}" {{ $loop->first ? 'selected' : '' }}>
                                                {{ $currency->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Type</label>
                                    <select data-placeholder="Select Report Type" id="report_type" name="report_type"
                                        class="tom-select w-full">
                                        <option value="">Please Select Report Type</option>
                                        <option selected value="1">Account Ledger With Cost Center</option>
                                        <option value="2">Account Ledger Without Cost Center</option>
                                        <option value="3">Account Ledger Without Cost Center And Voucher No</option>
                                        <option value="4">Account Ledger With Cost Center Opening</option>
                                        <option value="5">Account Ledger Contra</option>
                                        <option value="6">Account Ledger Summary</option>
                                        <option value="7">Account Ledger Summary Month Wise</option>
                                    </select>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Status</legend>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_status"
                                                id="all" value="all" checked>
                                            <label class="form-check-label" for="all">All</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="report_status"
                                                id="approved" value="approved">
                                            <label class="form-check-label" for="approved">Approved</label>
                                        </div>
                                    </fieldset>
                                </div>
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Report Condition</legend>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="exclude_zero_balance"
                                                id="exclude_zero_balance" value="1"
                                                {{ old('exclude_zero_balance') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="exclude_zero_balance">Exclude Zero
                                                Balance</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox"
                                                name="exclude_inactive_account" id="exclude_inactive_account"
                                                value="1" {{ old('exclude_inactive_account') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="exclude_inactive_account">Exclude
                                                In-Active Account</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="show_filter"
                                                id="show_filter" value="1"
                                                {{ old('show_filter') ? 'checked' : '' }}>
                                            <label class="form-check-label" for="show_filter">Show Filter</label>
                                        </div>
                                    </fieldset>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend>Order By</legend>
                                        <div class="form-check form-check-inline">
                                            <input checked class="form-check-input" type="radio" name="order_by"
                                                id="account_code" value="account_code"
                                                {{ old('order_by') == 'account_code' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="account_code">Account Code</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="order_by"
                                                id="name" value="name"
                                                {{ old('order_by') == 'name' ? 'checked' : '' }}>
                                            <label class="form-check-label" for="name">Account Name</label>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-check mb-3">
                                        <input class="form-check-input" type="checkbox" name="source_doc_no"
                                            id="source_doc_no" value="1"
                                            {{ old('source_doc_no') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="source_doc_no">Show Source Doc No Instead of
                                            Voucher No</label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" name="hide_cheque_date"
                                            id="hide_cheque_date" value="1"
                                            {{ old('hide_cheque_date') ? 'checked' : '' }}>
                                        <label class="form-check-label" for="hide_cheque_date">Do not Show Cheque
                                            Date</label>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <script>
        window.onload = function() {
            document.getElementById('myForm').reset(); // Replace 'yourFormId' with the actual form ID
        };
    </script>
@endsection
