@extends('layout.master')

@section('title')
    Account Ledger Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Account Ledger Report</a>
@endsection

<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th,
    td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }
</style>

@section('content')
    {{-- <div class="page-body"> --}}
        {{-- <div class="container-fluid">
            <div class="page-title">
                <div class="row">
                    <div class="col-6">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ url('accounts/dashboard') }}">
                                    <svg class="stroke-icon">
                                        <use href="{{ url('/assets/svg/icon-sprite.svg#stroke-home') }}"></use>
                                    </svg></a></li>
                            <li class="breadcrumb-item active">Accounts Ledger Report</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div> --}}
        <div class="grid columns-12 gap-6 mt-5">
            <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2"
                style="text-align: center;">
                <img src="{{ url('logo-invoice.png') }}" alt=""
                    style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
                <div style="flex-grow: 1;">
                    <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                        YARAN SHIPPING LINE
                    </h2>
                    <h3 class="font-medium pb-10" style="text-align: center;">
                        Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                    </h3>
                    <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
                </div>
            </div>

            <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
                <button id="printButton" class="btn btn-primary me-3">
                    <i class="fas fa-print"></i> Print
                </button>
                <!-- Export as Excel -->
                <form action="{{ url('/accounts/account-ledger') }}" method="POST">
                    @csrf
                    {{-- basics --}}
                    <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                    <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                    <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">
                    <input type="hidden" name="report_type" value="{{ request('report_type') }}">
                    <input type="hidden" name="order_by" value="{{ request('order_by', 'account_code') }}">

                    {{-- radios / checkboxes --}}
                    @if (request()->filled('report_status'))
                        <input type="hidden" name="report_status" value="{{ request('report_status') }}">
                    @endif

                    @if (request()->boolean('exclude_zero_balance'))
                        <input type="hidden" name="exclude_zero_balance" value="1">
                    @endif

                    @if (request()->boolean('exclude_inactive_account'))
                        <input type="hidden" name="exclude_inactive_account" value="1">
                    @endif

                    @if (request()->boolean('show_filter'))
                        <input type="hidden" name="show_filter" value="1">
                    @endif

                    @if (request()->boolean('source_doc_no'))
                        <input type="hidden" name="source_doc_no" value="1">
                    @endif

                    @if (request()->boolean('hide_cheque_date'))
                        <input type="hidden" name="hide_cheque_date" value="1">
                    @endif

                    {{-- arrays --}}
                    @if (is_array(request('parent_account_id')))
                        @foreach (request('parent_account_id') as $parent_id)
                            @if(!is_null($parent_id) && $parent_id !== '')
                                <input type="hidden" name="parent_account_id[]" value="{{ $parent_id }}">
                            @endif
                        @endforeach
                    @endif

                    @if (is_array(request('child_account')))
                        @foreach (request('child_account') as $child_id)
                            @if(!is_null($child_id) && $child_id !== '')
                                <input type="hidden" name="child_account[]" value="{{ $child_id }}">
                            @endif
                        @endforeach
                    @endif

                    {{-- export --}}
                    <input type="hidden" name="export_type" value="xlsx">
                    <button type="submit" class="btn btn-success me-3">Export to Excel</button>
                </form>


                <!-- Export as CSV -->
                <form action="{{ url('/accounts/account-ledger') }}" method="POST">
                    @csrf
                    <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                    <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                    @if (is_array(request('parent_account_id')))
                        @foreach (request('parent_account_id') as $parent_id)
                            <input type="hidden" name="parent_account_id[]" value="{{ $parent_id }}">
                        @endforeach
                    @endif

                    @if (is_array(request('child_account')))
                        @foreach (request('child_account') as $child_id)
                            <input type="hidden" name="child_account[]" value="{{ $child_id }}">
                        @endforeach
                    @endif

                    <input type="hidden" name="export_type" value="csv">
                    <button type="submit" class="btn btn-primary">Export to CSV</button>
                </form>

            </div>

            <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">

                {{-- <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
                    <button id="printButton" class="btn btn-primary">
                        <i class="fas fa-print"></i> Print
                    </button>
                </div> --}}

                <!-- Container-fluid starts-->
                {{-- <div class="container-fluid">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body"> --}}
                                    <div class="custom">
                                        @php
                                            $grandDebitOpening = 0;
                                            $grandCreditOpening = 0;
                                            $grandDebitCurrent = 0;
                                            $grandCreditCurrent = 0;
                                            $grandDebitBalance = 0;
                                            $currency_id = 1;
                                            $exchange_rate = 1;
                                        @endphp

                                        {{-- Loop each account --}}
                                        @foreach ($allLedgerReports as $accountName => $ledger)
                                            <table class="table table-bordered mt-n2 display nowrap">
                                                <thead>
                                                    <tr>
                                                        <th colspan="{{ $report_type != 3 ? ($report_type == 1 ? 12 : 11) : 10 }}"
                                                            class="text-center">{{ $ledger['account_name'] }}</th>
                                                    </tr>
                                                    <tr>
                                                        <th style="width:10%">Sno</th>
                                                        <th style="width:10%">Date</th>
                                                        @if ($report_type != 3)
                                                            <th style="width:10%">Voucher #</th>
                                                        @endif
                                                        <th style="width:30%">Particular</th>
                                                        @if ($report_type == 1)
                                                            <th style="width:5%">C C</th>
                                                        @endif
                                                        <th style="width:15%">Chq / Ref #</th>
                                                        @if ($hide_cheque_date != 1)
                                                            <th style="width:25%">Chq / Ref Date</th>
                                                        @endif
                                                        <th style="width:15%">Debit</th>
                                                        <th style="width:15%">Credit</th>
                                                        <th style="width:15%">Debit (LC)</th>
                                                        <th style="width:15%">Credit (LC)</th>
                                                        <th style="width:15%">Balance</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    {{-- Opening Balance --}}
                                                    <tr>
                                                        <td></td>
                                                        <td>Opening</td>
                                                        @if ($report_type != 3)
                                                            <td></td>
                                                        @endif
                                                        <td></td>
                                                        @if ($report_type == 1)
                                                            <td></td>
                                                        @endif
                                                        <td>{{ $ledger['debit_opening'] > 0 ? $ledger['debit_opening'] : '' }}
                                                        </td>
                                                        <td>{{ $ledger['credit_opening'] > 0 ? $ledger['credit_opening'] : '' }}
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        @if ($hide_cheque_date != 1)
                                                            <td></td>
                                                        @endif
                                                    </tr>

                                                    @php $sno = 1; @endphp
                                                    {{-- Transaction Rows --}}
                                                    @foreach ($ledger['ledgerReport'] as $entry)
                                                        <tr>
                                                            <td>{{ $sno++ }}</td>
                                                            <td>{{ $entry['date'] }}</td>
                                                            @if ($report_type != 3)
                                                                <td>
                                                                    <a
                                                                        href="{{ url('accounts/general-voucher/edit/' . $entry['transaction_id']) }}">
                                                                        {{ @$entry['voucher_no'] }}
                                                                    </a>
                                                                </td>
                                                            @endif
                                                            <td>{{ @$entry['narration'] }}</td>
                                                            @if ($report_type == 1)
                                                                <td>Head Office</td>
                                                            @endif
                                                            <td>{{ @$entry['reference_number'] }}</td>
                                                            @if ($hide_cheque_date != 1)
                                                                <td>{{ @$entry['reference_date'] }}</td>
                                                            @endif
                                                            <td>{{ $entry['debit_vc'] }}</td>
                                                            <td>{{ $entry['credit_vc'] }}</td>
                                                            <td>{{ $entry['debit'] }}</td>
                                                            <td>{{ $entry['credit'] }}</td>
                                                            <td>{{ abs($entry['closing_balance'])}}
                                                                {{ $entry['closing_balance'] < 0 ? 'CR' : 'DR' }}
                                                            </td>
                                                        </tr>
                                                    @endforeach

                                                    {{-- Total Row for this account --}}
                                                    <tr>
                                                        <td colspan="6" class="text-center fw-bold">Total</td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td>{{ $ledger['debit_current'] }}</td>
                                                        <td>{{ $ledger['credit_current'] }}</td>
                                                        <td>{{ abs($ledger['debit_balance']) }}
                                                            {{ $ledger['debit_balance'] < 0 ? 'CR' : 'DR' }}
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                            {{-- Accumulate grand totals --}}
                                            @php
                                                $grandDebitOpening += $ledger['debit_opening'];
                                                $grandCreditOpening += $ledger['credit_opening'];
                                                $grandDebitCurrent += $ledger['debit_current'];
                                                $grandCreditCurrent += $ledger['credit_current'];
                                                $grandDebitBalance += $ledger['debit_balance'];
                                            @endphp
                                        @endforeach

                                        {{-- Grand Total Table (only once, after loop) --}}
                                        <table class="table table-bordered mt-4">
                                            <tfoot>
                                                <tr>
                                                    <th width="70%" class="text-end">Grand Total</th>
                                                    <th width="10%">{{ $grandDebitCurrent + $ledger['debit_opening'] }}</th>
                                                    <th width="10%">{{ $grandCreditCurrent + $ledger['credit_opening'] }}
                                                    </th>
                                                    <th width="10%">{{ abs($grandDebitBalance) }}
                                                        {{ $grandDebitBalance < 0 ? 'CR' : 'DR' }}
                                                    </th>
                                                </tr>
                                            </tfoot>
                                        </table>


                                        {{-- Grand Total Row --}}
                                        {{-- <table class="table table-bordered mt-n2 display nowrap"
                                            style="margin-top: 20px;">
                                            <tbody>
                                                <tr>
                                                    <th colspan="4">Grand Total</th>
                                                    <th>{{ $grandDebitCurrent }}</th>
                                                    <th>{{ $grandCreditCurrent }}</th>
                                                    <th>{{ $grandDebitBalance }}</th>
                                                    <th></th>
                                                    <th></th>
                                                </tr>
                                            </tbody>
                                        </table> --}}
                                    </div>
                                    {{--
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}
            </div>
            <!-- Container-fluid Ends-->
        </div>

        <script>
            document.getElementById("printButton").addEventListener("click", function () {
                var printContents = document.querySelector(".custom").innerHTML;
                var originalContents = document.body.innerHTML;

                document.body.innerHTML = `
                            <html>
                                <head>
                                    <title>Account Ledger Report - YARAN</title>
                                    <style>
                                        html {
                                            background-color: white;
                                        }
                                        body {
                                            font-family: Arial, sans-serif;
                                            background-color: white;
                                        }
                                        table {
                                            width: 100%;
                                            border-collapse: collapse;
                                            margin-bottom: 20px;
                                        }
                                        th, td {
                                            border: 1px solid #ddd;
                                            padding: 8px;
                                            text-align: left;
                                        }
                                        th {
                                            background-color: #1c3faa;
                                            color: #fff;
                                        }
                                        h1 {
                                            text-align: center;
                                        }
                                        @media print {
                                            table {
                                                font-size: 10px; /* smaller text */
                                                table-layout: fixed; /* enforce column widths */
                                                width: 100%;
                                            }
                                            th, td {
                                                padding: 4px;
                                                word-wrap: break-word;
                                            }
                                        }
                                    </style>
                                </head>
                                <body>
                                    <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                                        <div style="flex-grow: 1;">
                                            <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                                Account Ledger Report
                                            </h2>
                                    </div>
                                    <div style="margin-top: 10px">
                                        ${printContents}
                                    </div>
                                </body>
                            </html>
                        `;

                window.print();
                document.body.innerHTML = originalContents;
                location.reload(); // Reload to restore the original content
            });
        </script>
@endsection