@extends('layout.master')

@section('title')
    Ageing-Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('/accounts/ageing-report') }}" class="breadcrumb-item">Ageing Report</a><i data-feather="chevron-right"
        class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/ageing-report') }}" enctype="multipart/form-data"
                class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Ageing Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date" value="{{ $date_from }}" name="date_from" id="date_from"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}" name="date_to" id="date_to"
                                        class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-4">
                                    <label>Party Account</label>
                                    <select data-placeholder="Select Account" id="account_id"
                                        name="account_id" class="tom-select w-full">
                                        <option value="">Please Select Parent Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>



                                <div class="col-md-4 mt-4">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Currency</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-4">
                                    <label for="cost_center">Cost Center</label>
                                    <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                        class="tom-select w-full">
                                        <option value=""></option>
                                        <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                            value="Head Office">Head Office</option>
                                    </select>
                                </div>
                            </div>

                            {{-- <div class="row">
                                <div class="col-md-4 ">
                                    <label for="Department">Department</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Department" id="Department" name="Department"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('Department') == 'HO' ? 'selected' : '' }} value="HO">HO
                                            </option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 ">
                                    <label for="Location">Location</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Location" id="Location" name="Location"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 ">
                                    <label for="Project">Project</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Project" id="Project" name="Project"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="Job#">Job#</label>
                                    <div>
                                        <input type="number" class="form-control" placeholder="Please Enter Job No"
                                            name="job_no">
                                    </div>
                                </div>
                                <div class="col-md-4 mt-2">
                                    <label for="Report_type">Report Type</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Report type" id="Report_type" name="Report_type"
                                            class="tom-select w-full mt-2">
                                            <option value=""></option>
                                            <option {{ request('Report_type') == 'Ageing Detail' ? 'selected' : '' }}
                                                value="Ageing Detail">Ageing Detail</option>
                                            <option {{ request('Report_type') == 'Ageing Summary' ? 'selected' : '' }}
                                                value="Ageing Summary">Ageing Summary</option>
                                            <option {{ request('Report_type') == 'Ageing Weekly' ? 'selected' : '' }}
                                                value="Ageing Weekly">Ageing Weekly</option>
                                            <option {{ request('Report_type') == 'Ageing Monthly' ? 'selected' : '' }}
                                                value="Ageing Monthly">Ageing Monthly</option>
                                            <option
                                                {{ request('Report_type') == 'Ageing Summary Five Year' ? 'selected' : '' }}
                                                value="Ageing Summary Five Year">Ageing Summary Five Year</option>
                                        </select>
                                    </div>
                                </div>


                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <fieldset class="mb-3">
                                        <legend></legend>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="exclude_zero">
                                            <label class="form-check-label" for="exclude_zero">Exclude Zero
                                                Balance</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="Exclude_Settlement">
                                            <label class="form-check-label" for="Exclude_Settlement">Exclude
                                                Settlement</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="each_group">
                                            <label class="form-check-label" for="each_group">Print each group in new
                                                page</label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="date_range">
                                            <label class="form-check-label" for="date_range">Apply Date Range on
                                                Receipt</label>
                                        </div>
                                    </fieldset>
                                </div>

                                <div class="col-md-12 pt-4">
                                    <label> </label>
                                    <div class="pt-3 ">

                                        <input type="radio" id="Date" name="Due_Date" value="one">
                                        <label for="Due_Date">Due Date </label>


                                        <input type="radio" id="Date" name="Voucher_Date" class="px-3"
                                            value="two">
                                        <label for="Voucher_Date">Voucher Date</label>

                                    </div>
                                </div>
                                <div class="col-md-12 pt-4">
                                    <label> Date</label>
                                    <div class="pt-3 ">
                                        <input type="radio" id="Date" name="Date" value="one">
                                        <label for="current_date">Curent Date </label>


                                        <input type="radio" id="Date" name="Date" class="px-3"
                                            value="two">
                                        <label for="till_date">Till Date</label>


                                    </div>
                                </div>
                            </div> --}}

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        function toggleCheckboxes() {

            const isPLChecked = document.getElementById('pl_checkbox').checked;


            const checkboxes = ['assets', 'capital_expense', 'liabilities'];


            checkboxes.forEach(id => {
                const checkbox = document.getElementById(id);
                if (isPLChecked) {

                    checkbox.disabled = true;
                } else {
                    checkbox.disabled = false;
                }
            });
        }
    </script>
@endsection
