@extends('layout.master')

@section('title')
    Ageing-Detail-Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Ageing Detail Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>


        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="jobBalancingReport"
                style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Due Date</th>
                        <th>Voucher No</th>
                        <th>Code</th>
                        <th>Invoice No</th>
                        <th>Particular</th>
                        <th>Currency</th>
                        <th>Receivable</th>
                        <th>Received</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                @php
                    $totalReceivable = 0;
                    $totalPaid = 0;
                    $totalBalance = 0;
                @endphp
                <tbody>
                    @foreach ($receivables as $receivable)
                        <tr>
                            <td>{{ $receivable->Date }}</td>
                            <td>{{ $receivable->DueDate }}</td>
                            <td>{{ $receivable->VoucherNo }}</td>
                            <td>{{ $receivable->Code }}</td>
                            <td>{{ $receivable->InvoiceNo }}</td>
                            <td>{{ $receivable->Particular }}</td>
                            <td>{{ $receivable->curr }}</td>
                            <td>{{ number_format($receivable->Receivable, 2) }}</td>
                            <td>{{ number_format($receivable->Paid, 2) }}</td>
                            <td>{{ number_format($receivable->Balance, 2) }}</td>
                        </tr>
                        @php
                            $totalReceivable += $receivable->Receivable;
                            $totalPaid += $receivable->Paid;
                            $totalBalance += $receivable->Balance;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">TOTAL:</th>
                        <th>{{ number_format($totalReceivable, 2) }}</th>
                        <th>{{ number_format($totalPaid, 2) }}</th>
                        <th>{{ number_format($totalBalance, 2) }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <table class="table table-bordered mt-n2 display nowrap" id="Report" style="display: none; width:100%">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Due Date</th>
                        <th>Voucher No</th>
                        <th>Code</th>
                        <th>Invoice No</th>
                        <th>Particular</th>
                        <th>Currency</th>
                        <th>Payable</th>
                        <th>Paid</th>
                        <th>Balance</th>
                    </tr>
                </thead>
                @php
                    $totalPayable = 0;
                    $totalReceived = 0;
                    $totalPayableBalance = 0;
                @endphp
                <tbody>
                    @foreach ($payables as $payable)
                        <tr>
                            <td>{{ $payable->Date }}</td>
                            <td>{{ $payable->DueDate }}</td>
                            <td>{{ $payable->VoucherNo }}</td>
                            <td>{{ $payable->Code }}</td>
                            <td>{{ $payable->InvoiceNo }}</td>
                            <td>{{ $payable->Particular }}</td>
                            <td>{{ $payable->curr }}</td>
                            <td>{{ number_format($payable->Payable, 2) }}</td>
                            <td>{{ number_format($payable->Received, 2) }}</td>
                            <td>{{ number_format($payable->Balance, 2) }}</td>
                        </tr>
                        @php
                            $totalPayable += $payable->Payable;
                            $totalReceived += $payable->Received;
                            $totalPayableBalance += $payable->Balance;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="7">TOTAL:</th>
                        <th>{{ number_format($totalPayable, 2) }}</th>
                        <th>{{ number_format($totalReceived, 2) }}</th>
                        <th>{{ number_format($totalPayableBalance, 2) }}</th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- DataTables Core Script -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

    <!-- DataTables Buttons Extension -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>

    <!-- JSZip (Required for Excel export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

    <!-- PDFMake (Required for PDF export) -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.36/vfs_fonts.js"></script>

    <!-- Buttons for Excel and PDF -->
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>


    <script>
        $(document).ready(function() {
            // Check if DataTable library is loaded
            if ($.fn.dataTable) {
                // Initialize the DataTable
                $('#jobBalancingReport').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                        extend: 'excelHtml5',
                        text: 'Export to Excel',
                        title: 'Ageing Detail Report',
                        exportOptions: {
                            columns: ':visible' // Export only visible columns
                        }
                    }, ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#jobBalancingReport').show();
                    }
                });
                $('#Report').DataTable({
                    dom: 'Bfrtip', // Include export buttons in the DOM
                    buttons: [{
                        extend: 'excelHtml5',
                        text: 'Export to Excel',
                        title: 'Ageing Detail Report',
                        exportOptions: {
                            columns: ':visible' // Export only visible columns
                        }
                    }, ],
                    initComplete: function() {
                        // Show the table after DataTables initialization is complete
                        $('#Report').show();
                    }
                });
            }
        });
    </script>
@endsection
