@foreach ($data as $category => $subcategories)
    @if ($category != 'total')
        <tr>
            <th colspan="3">{{ $category }}</th> 
        </tr>

        @foreach ($subcategories as $subcategory => $amount)
            @if ($subcategory != 'total')
                <tr>
                    @if (is_array($amount)) 
                        {{-- Nested subcategory --}}
                        <td></td>
                        <td>{{ $subcategory }}</td> 
                        <td></td>
                    @else
                        {{-- Subcategory value --}}
                        <td></td>
                        <td>{{ $subcategory }}</td>
                        <td>{{ number_format($amount, 2) }}</td>
                    @endif
                </tr>

                @if (is_array($amount))
                    @foreach ($amount as $nestedSubcategory => $nestedAmount)
                        @if ($nestedSubcategory != 'total')
                            <tr>
                                <td></td>
                                <td>{{ $nestedSubcategory }}</td>
                                <td>{{ number_format($nestedAmount, 2) }}</td>
                            </tr>
                        @endif
                    @endforeach

                    {{-- Add total for nested subcategory if exists --}}
                    <tr>
                        <td></td>
                        <td>Total For {{ $subcategory }}</td>
                        <td>{{ number_format($amount['total'], 2) }}</td>
                    </tr>
                @endif
            @endif
        @endforeach

        <tr>
            <td colspan="2">Total For {{ $category }}</td>
            <td>{{ number_format($subcategories['total'], 2) }}</td>
        </tr>

        {{-- Additional empty row for visual separation --}}
        @if ($loop->last && $mainCategory !== 'EXPENSES')
            <tr>
                <td colspan="3"></td> 
            </tr>
        @endif
    @endif
@endforeach

{{-- Total for main category (if it's not the grand total) --}}
@if (isset($mainCategory))
    <tr>
        <th colspan="2">Total For {{ $mainCategory }}</th>
        <th>{{ number_format($data['total'], 2) }}</th>
    </tr>
@endif
