@extends('layout.master')

@section('title')
    Balance Sheet Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Balance Sheet Report</a>
@endsection

<style>
    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th,
    td {
        border: 1px solid #ddd;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }
</style>


@section('content')
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/balance-sheet') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/balance-sheet') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>

        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            {{-- <div class="container">
        <h1 class="text-center mb-4">Balance Sheet</h1>
        <h2 class="text-center">As of {{ date('F d, Y') }}</h2>

        <div class="text-center mb-3">
            <button id="printButton" class="btn btn-primary">
                <i class="fas fa-print"></i> Print
            </button>
        </div> --}}


            {{-- <div class="row mt-5">
            <div class="col-md-6">
                <h3>Assets</h3>

                <table class="table table-bordered">
                    <tbody>
                        @foreach ($assets as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <th colspan="2">{{ $category }}</th>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td><strong>Total {{ $category }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subcategories['total'], 2) }}</strong></td>
                                </tr>
                            @endif
                        @endforeach
                        <tr>
                            <th>Total Assets</th>
                            <th class="text-right">{{ number_format($assets['total'], 2) }}</th>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="col-md-6">
                <h3>Liabilities and Equity</h3>
                <table class="table table-bordered">
                    <tbody>
                        <tr>
                            <th colspan="2">Liabilities</th>
                        </tr>
                        @foreach ($liabilities as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <td colspan="2"><strong>{{ $category }}</strong></td>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td>Total {{ $category }}</td>
                                    <td class="text-right">{{ number_format($subcategories['total'], 2) }}</td>
                                </tr>
                            @endif
                        @endforeach
                        <tr>
                            <th>Total Liabilities</th>
                            <th class="text-right">{{ number_format($liabilities['total'], 2) }}</th>
                        </tr>

                        <tr>
                            <th colspan="2">Equity</th>
                        </tr>
                        @foreach ($capital as $category => $subcategories)
                            @if ($category != 'total')
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                        <tr>
                            <td>Net Income</td>
                            <td class="text-right">{{ number_format($revenue['total'] - $expenses['total'], 2) }}</td>
                        </tr>
                        <tr>
                            <th>Total Equity</th>
                            <th class="text-right">{{ number_format($capital['total'] + $revenue['total'] - $expenses['total'], 2) }}</th>
                        </tr>

                        <tr>
                            <th>Total Liabilities and Equity</th>
                            <th class="text-right">{{ number_format($liabilities['total'] + $capital['total'] + $revenue['total'] - $expenses['total'], 2) }}</th>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div> --}}
            <div class="custom">
                <div class="g-col-12 text-center my-4">
                    <h1 class="fw-bold" style="font-size: 28px; margin-bottom: 10px;">Balance Sheet</h1>
                    <h2 class="text-muted" style="font-size: 20px;">As of {{ date('F d, Y') }}</h2>
                </div>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th colspan="2" class="text-center">Particulars</th>
                            <th class="text-center">Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        {{-- ASSETS --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Assets</th>
                        </tr>
                        @foreach ($assets as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <td colspan="2"><strong>{{ $category }}</strong></td>
                                    <td></td>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td><strong>Total {{ $category }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($subcategories['total'], 2) }}</strong>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                        <tr class="table-secondary">
                            <th colspan="2">Total Assets</th>
                            <th class="text-right">{{ number_format($assets['total'], 2) }}</th>
                        </tr>

                        {{-- LIABILITIES --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Liabilities</th>
                        </tr>
                        @foreach ($liabilities as $category => $subcategories)
                            @if ($category != 'total')
                                <tr>
                                    <td colspan="2"><strong>{{ $category }}</strong></td>
                                    <td></td>
                                </tr>
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td>Total {{ $category }}</td>
                                    <td class="text-right">{{ number_format($subcategories['total'], 2) }}</td>
                                </tr>
                            @endif
                        @endforeach
                        <tr class="table-secondary">
                            <th colspan="2">Total Liabilities</th>
                            <th class="text-right">{{ number_format($liabilities['total'], 2) }}</th>
                        </tr>

                        {{-- EQUITY --}}
                        <tr>
                            <th colspan="3" class="text-center bg-light">Equity</th>
                        </tr>
                        @foreach ($capital as $category => $subcategories)
                            @if ($category != 'total')
                                @foreach ($subcategories as $subcategory => $amount)
                                    @if ($subcategory != 'total')
                                        <tr>
                                            <td></td>
                                            <td>{{ $subcategory }}</td>
                                            <td class="text-right">{{ number_format($amount, 2) }}</td>
                                        </tr>
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                        <tr>
                            <td></td>
                            <td>Net Income</td>
                            <td class="text-right">{{ number_format($revenue['total'] - $expenses['total'], 2) }}</td>
                        </tr>
                        <tr class="table-secondary">
                            <th colspan="2">Total Equity</th>
                            <th class="text-right">
                                {{ number_format($capital['total'] + $revenue['total'] - $expenses['total'], 2) }}</th>
                        </tr>

                        {{-- TOTAL LIABILITIES AND EQUITY --}}
                        <tr class="table-dark text-white">
                            <th colspan="2">Total Liabilities and Equity</th>
                            <th class="text-right">
                                {{ number_format($liabilities['total'] + $capital['total'] + $revenue['total'] - $expenses['total'], 2) }}
                            </th>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <script>
            document.getElementById("printButton").addEventListener("click", function() {
                var printContents = document.querySelector(".custom").innerHTML;
                var originalContents = document.body.innerHTML;

                document.body.innerHTML = `
                <html>
                    <head>
                        <style>
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 100%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

                window.print();
                document.body.innerHTML = originalContents;
                location.reload(); // Reload to restore the original content
            });
        </script>
    @endsection
