@extends('layout.master')

@section('title')
    Budget-Variance-Report-YARAN
@endsection

@section('topbar')
    <a href="{{ url('/accounts/buget-variance-report') }}" class="breadcrumb-item"> Budget Variance Report</a><i
        data-feather="chevron-right" class="breadcrumb__icon"></i><a href="" class="breadcrumb--active">Filters</a>
@endsection
@section('content')
    <div class="row mt-5">
        <div class="col-md-12 ">
            <!-- BEGIN: Input -->
            <form method="POST" id="myForm" action="{{ url('/accounts/buget-variance-report') }}"
                enctype="multipart/form-data" class="row g-3">
                @csrf
                <div class="intro-y box">
                    <div
                        class="d-flex flex-column flex-sm-row align-items-center p-5 border-bottom border-gray-200 dark-border-dark-5">
                        <h2 class="fw-medium fs-base me-auto">
                            Budget Variance Report
                        </h2>

                        <button type="submit" class="btn btn-primary submitBtn" id="submitBtn">Generate Report</button>
                        {{-- <a href="{{ url('/accounts/chart_of_account') }}" type="back"
                            class="btn btn-secondary waves-effect">
                            Back
                        </a> --}}
                    </div>

                    <div id="input" class="p-5">
                        <div class=" col-md-12">
                            <div class="row mb-5">

                                <div class="col-md-4">
                                    <label for="date_from">Date From</label>
                                    <input type="date"
                                        value="{{ $date_from }}"
                                        name="date_from" id="date_from" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label for="date_to">Date To</label>
                                    <input type="date" value="{{ $date_to }}"
                                        name="date_to" id="date_to" class="form-control">
                                </div>

                                <div class="col-md-4">
                                    <label> Account</label>
                                    <select data-placeholder="Select Account" name="account_id"
                                        class="tom-select w-full parent_account_id">
                                        <option value="">Please Select Account</option>
                                        @foreach ($parent_accounts as $account)
                                            <option value="{{ $account->id }}">{{ $account->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2 ">
                                    <label>Company</label>
                                    <select data-placeholder="Select Company" id="company" name="company"
                                        class="tom-select w-full ">
                                        <option value="1" {{ request('company') == 1 ? 'selected' : '' }}>YARAN
                                            SHIPPING LINE</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label>Currency</label>
                                    <select data-placeholder="Select Currency" id="currency_id" name="currency_id"
                                        class="tom-select w-full">
                                        <option value="">Please Select Currency</option>
                                        @foreach ($currencies as $currency)
                                            <option value="{{ $currency->id }}">{{ $currency->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="col-md-4 mt-2">
                                    <label for="cost_center">Cost Center</label>
                                    <div class="d-flex align-items-center">
                                        <select data-placeholder="Select Cost Center" id="cost_center" name="cost_center"
                                            class="tom-select w-full ">
                                            <option value=""></option>
                                            <option {{ request('cost_center') == 'Head Office' ? 'selected' : '' }}
                                                value="Head Office">Head Office</option>
                                        </select>
                                    </div>
                                </div>
                                {{-- <div class="col-md-12 pt-4">
                                    <label>Report</label>
                                    <div class="mt-3">
                                        <input type="radio" id="budge_detail" name="report" value="one" checked>
                                        <label for="budge_detail">Budge Detail</label>

                                        <input type="radio" id="budget_summary" name="report" class="ms-3"
                                            value="two">
                                        <label for="budget_summary">Budget Summary</label>


                                    </div>
                                </div> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
