@extends('layout.master')

@section('title')
    Budget-Variance-Report-YARAN
@endsection

@section('topbar')
    <a href="" class="breadcrumb--active">Budget Variance Report</a>
@endsection

@section('content')
    {{-- <div class="row mt-5"> --}}
    <div class="grid columns-12 gap-6 mt-5">
        <div class="intro-y g-col-12 d-flex flex-wrap flex-sm-nowrap align-items-center mt-2" style="text-align: center;">
            <img src="{{ url('logo-invoice.png') }}" alt=""
                style="width: 200px; border: 1px solid rgb(148, 144, 144); border-left: none; border-right: none; padding-bottom: 8px; border-top: none;  margin-bottom: 10px;">
            <div style="flex-grow: 1;">
                <h2 class="font-bold" style="font-size: 20px !important; font-weight: bold; text-align: center;">
                    YARAN SHIPPING LINE
                </h2>
                <h3 class="font-medium pb-10" style="text-align: center;">
                    Suite # 205, Emarah Suites, Sharah-e-Faisal, Karachi, Pakistan.
                </h3>
                <p style="text-align: center;">Email: info@yaranshippingline.com Web: www.yaranshippingline.com</p>
            </div>
        </div>

        <div class="intro-y g-col-12 d-flex justify-content-end mb-3">
            <button id="printButton" class="btn btn-primary me-3">
                <i class="fas fa-print"></i> Print
            </button>
            <!-- Export as Excel -->
            <form action="{{ url('/accounts/buget-variance-report') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">

                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">
                <input type="hidden" name="export_type" value="xlsx">
                <button type="submit" class="btn btn-success me-3">Export to Excel</button>
            </form>

            <!-- Export as CSV -->
            <form action="{{ url('/accounts/buget-variance-report') }}" method="POST">
                @csrf
                <input type="hidden" name="date_from" value="{{ request('date_from') }}">
                <input type="hidden" name="date_to" value="{{ request('date_to') }}">
                <input type="hidden" name="account_id" value="{{ request('account_id') }}">
                <input type="hidden" name="currency_id" value="{{ request('currency_id') }}">
                <input type="hidden" name="export_type" value="csv">
                <button type="submit" class="btn btn-primary">Export to CSV</button>
            </form>

        </div>
        <div class="intro-y g-col-12 overflow-auto overflow-lg-visible">
            <div class="custom">
                <table class="table table-bordered mt-n2 display nowrap">
                    <thead>
                        <tr>
                            <th>S #</th>
                            <th>Invoice #</th>
                            <th>Trn Date</th>
                            <th>Particular</th>
                            <th>Debit</th>
                            <th>Credit</th>
                            <th>Balance</th>
                            <th>Type</th>
                            <th>Budget</th>
                            <th>Bal Budget</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($formattedDetails as $groupIndex => $group)
                            <!-- Group Header -->
                            <tr>
                                <td colspan="10" class="bg-light">
                                    <strong>{{ $group['group_key'] }}</strong>
                                </td>
                            </tr>

                            <!-- Group Transactions -->
                            @foreach ($group['transactions'] as $transactionIndex => $transaction)
                                <tr>
                                    <td>{{ $loop->parent->iteration }}.{{ $transactionIndex + 1 }}</td> <!-- S # -->
                                    <td>{{ $transaction['voucher_no'] }}</td> <!-- Trn Date -->
                                    <td>{{ $transaction['date'] }}</td> <!-- Trn Date -->
                                    <td>{{ $transaction['particulars'] }}</td> <!-- Particular -->
                                    <td>{{ number_format($transaction['debit'], 2) }}</td> <!-- Debit -->
                                    <td>{{ number_format($transaction['credit'], 2) }}</td> <!-- Credit -->
                                    <td>{{ number_format($transaction['balance'], 2) }}</td> <!-- balance -->
                                    <td>{{ $transaction['debit'] > 0 ? 'Dr' : 'Cr' }}</td>
                                    <td>0.00</td>
                                    <td>{{ number_format($transaction['budget_balance'], 2) }}</td> <!-- budget_balance -->
                                </tr>
                            @endforeach

                            <!-- Group Totals -->
                            <tr class="font-weight-bold">
                                <td colspan="4" class="text-right">Total:</td>
                                <td>{{ number_format($group['totals']['total_debit'], 2) }}</td>
                                <td>{{ number_format($group['totals']['total_credit'], 2) }}</td>
                                <td>{{ number_format($group['totals']['balance'], 2) }}</td>
                                <td></td>
                                <td>0.00</td>
                                <td>{{ number_format($group['totals']['budget_balance'], 2) }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <script>
        document.getElementById("printButton").addEventListener("click", function() {
            var printContents = document.querySelector(".custom").innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = `
                <html>
                    <head>
                        <title>Budget Variance Report - YARAN</title>
                        <style>
                            @page {
                                size: landscape;
                            }
                            html {
                                background-color: white;
                            }
                            body {
                                font-family: Arial, sans-serif;
                                background-color: white;
                            }
                            table {
                                width: 80%;
                                border-collapse: collapse;
                                margin-bottom: 20px;
                            }
                            th, td {
                                border: 1px solid #ddd;
                                padding: 8px;
                                text-align: left;
                            }
                            th {
                                background-color: #f2f2f2;
                            }
                            h1 {
                                text-align: center;
                            }
                        </style>
                    </head>
                    <body>
                        <div style="display: flex; flex-wrap: wrap; align-items: center; margin-top: 2rem; text-align: center; margin-bottom: 10px;">
                            <div style="flex-grow: 1;">
                                <h2 style="font-size: 20px !important; font-weight: bold; text-align: center; text-transform: uppercase;">
                                    Budget Variance Report
                                </h2>
                        </div>
                        <div style="margin-top: 10px">
                            ${printContents}
                        </div>
                    </body>
                </html>
            `;

            window.print();
            document.body.innerHTML = originalContents;
            location.reload(); // Reload to restore the original content
        });
    </script>
@endsection
